// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.transform

import aws.sdk.kotlin.services.mediapackagev2.model.ContainerType
import aws.sdk.kotlin.services.mediapackagev2.model.CreateOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackagev2.model.GetHlsManifestConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
import aws.sdk.kotlin.services.mediapackagev2.model.MediaPackageV2Exception
import aws.sdk.kotlin.services.mediapackagev2.model.Segment
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class CreateOriginEndpointOperationDeserializer: HttpDeserialize<CreateOriginEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateOriginEndpointResponse {
        if (!response.status.isSuccess()) {
            throwCreateOriginEndpointError(context, response)
        }
        val builder = CreateOriginEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateOriginEndpointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateOriginEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MediaPackageV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOriginEndpointOperationBody(builder: CreateOriginEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CHANNELGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelGroupName"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChannelName"))
    val CONTAINERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ContainerType"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val HLSMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HlsManifests"))
    val LOWLATENCYHLSMANIFESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LowLatencyHlsManifests"))
    val MODIFIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ModifiedAt"))
    val ORIGINENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginEndpointName"))
    val SEGMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Segment"))
    val STARTOVERWINDOWSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StartoverWindowSeconds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CHANNELGROUPNAME_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(CONTAINERTYPE_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HLSMANIFESTS_DESCRIPTOR)
        field(LOWLATENCYHLSMANIFESTS_DESCRIPTOR)
        field(MODIFIEDAT_DESCRIPTOR)
        field(ORIGINENDPOINTNAME_DESCRIPTOR)
        field(SEGMENT_DESCRIPTOR)
        field(STARTOVERWINDOWSECONDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CHANNELGROUPNAME_DESCRIPTOR.index -> builder.channelGroupName = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                CONTAINERTYPE_DESCRIPTOR.index -> builder.containerType = deserializeString().let { ContainerType.fromValue(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HLSMANIFESTS_DESCRIPTOR.index -> builder.hlsManifests =
                    deserializer.deserializeList(HLSMANIFESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<GetHlsManifestConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGetHlsManifestConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LOWLATENCYHLSMANIFESTS_DESCRIPTOR.index -> builder.lowLatencyHlsManifests =
                    deserializer.deserializeList(LOWLATENCYHLSMANIFESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<GetLowLatencyHlsManifestConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGetLowLatencyHlsManifestConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MODIFIEDAT_DESCRIPTOR.index -> builder.modifiedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                ORIGINENDPOINTNAME_DESCRIPTOR.index -> builder.originEndpointName = deserializeString()
                SEGMENT_DESCRIPTOR.index -> builder.segment = deserializeSegmentDocument(deserializer)
                STARTOVERWINDOWSECONDS_DESCRIPTOR.index -> builder.startoverWindowSeconds = deserializeInt()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
