// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model



/**
 * Configure one or more content encryption keys for your endpoints that use SPEKE Version 2.0. The encryption contract defines which content keys are used to encrypt the audio and video tracks in your stream. To configure the encryption contract, specify which audio and video encryption presets to use.
 */
public class EncryptionContractConfiguration private constructor(builder: Builder) {
    /**
     * A collection of audio encryption presets.
     *
     * Value description:
     * + PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
     * + PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all of the multichannel audio tracks.
     * + PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio tracks with more than 6 channels.
     * + SHARED - Use the same content key for all of the audio and video tracks in your stream.
     * + UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
     */
    public val presetSpeke20Audio: aws.sdk.kotlin.services.mediapackagev2.model.PresetSpeke20Audio? = builder.presetSpeke20Audio
    /**
     * A collection of video encryption presets.
     *
     * Value description:
     * + PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
     * + PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD and higher resolutions video tracks.
     * + PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks and one content key for all UHD video tracks.
     * + PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     * + PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     * + PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
     * + PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
     * + PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
     * + SHARED - Use the same content key for all of the video and audio tracks in your stream.
     * + UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
     */
    public val presetSpeke20Video: aws.sdk.kotlin.services.mediapackagev2.model.PresetSpeke20Video? = builder.presetSpeke20Video

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionContractConfiguration(")
        append("presetSpeke20Audio=$presetSpeke20Audio,")
        append("presetSpeke20Video=$presetSpeke20Video")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = presetSpeke20Audio?.hashCode() ?: 0
        result = 31 * result + (presetSpeke20Video?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionContractConfiguration

        if (presetSpeke20Audio != other.presetSpeke20Audio) return false
        if (presetSpeke20Video != other.presetSpeke20Video) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A collection of audio encryption presets.
         *
         * Value description:
         * + PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks in your stream.
         * + PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio tracks and one content key to encrypt all of the multichannel audio tracks.
         * + PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio tracks, one content key to encrypt all of the multichannel audio tracks with 3 to 6 channels, and one content key to encrypt all of the multichannel audio tracks with more than 6 channels.
         * + SHARED - Use the same content key for all of the audio and video tracks in your stream.
         * + UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
         */
        public var presetSpeke20Audio: aws.sdk.kotlin.services.mediapackagev2.model.PresetSpeke20Audio? = null
        /**
         * A collection of video encryption presets.
         *
         * Value description:
         * + PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks in your stream.
         * + PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video tracks and one content key for all HD and higher resolutions video tracks.
         * + PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks and one content key for all UHD video tracks.
         * + PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video tracks, one content key for HD video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         * + PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         * + PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video tracks, one content key for HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
         * + PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks and one content key for all UHD video tracks.
         * + PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video tracks, one content key for HD2 video tracks, one content key for all UHD1 video tracks and one content key for all UHD2 video tracks.
         * + SHARED - Use the same content key for all of the video and audio tracks in your stream.
         * + UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
         */
        public var presetSpeke20Video: aws.sdk.kotlin.services.mediapackagev2.model.PresetSpeke20Video? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration) : this() {
            this.presetSpeke20Audio = x.presetSpeke20Audio
            this.presetSpeke20Video = x.presetSpeke20Video
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.EncryptionContractConfiguration = EncryptionContractConfiguration(this)
    }
}
