// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackagev2.model



/**
 * The parameters for encrypting content.
 */
public class Encryption private constructor(builder: Builder) {
    /**
     * A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
     */
    public val constantInitializationVector: kotlin.String? = builder.constantInitializationVector
    /**
     * The encryption method to use.
     */
    public val encryptionMethod: aws.sdk.kotlin.services.mediapackagev2.model.EncryptionMethod? = builder.encryptionMethod
    /**
     * The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.
     *
     * The following example setting causes the service to rotate keys every thirty minutes: `1800`
     */
    public val keyRotationIntervalSeconds: kotlin.Int? = builder.keyRotationIntervalSeconds
    /**
     * The parameters for the SPEKE key provider.
     */
    public val spekeKeyProvider: aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider? = builder.spekeKeyProvider

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackagev2.model.Encryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Encryption(")
        append("constantInitializationVector=$constantInitializationVector,")
        append("encryptionMethod=$encryptionMethod,")
        append("keyRotationIntervalSeconds=$keyRotationIntervalSeconds,")
        append("spekeKeyProvider=$spekeKeyProvider")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = constantInitializationVector?.hashCode() ?: 0
        result = 31 * result + (encryptionMethod?.hashCode() ?: 0)
        result = 31 * result + (keyRotationIntervalSeconds ?: 0)
        result = 31 * result + (spekeKeyProvider?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Encryption

        if (constantInitializationVector != other.constantInitializationVector) return false
        if (encryptionMethod != other.encryptionMethod) return false
        if (keyRotationIntervalSeconds != other.keyRotationIntervalSeconds) return false
        if (spekeKeyProvider != other.spekeKeyProvider) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackagev2.model.Encryption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting content. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
         */
        public var constantInitializationVector: kotlin.String? = null
        /**
         * The encryption method to use.
         */
        public var encryptionMethod: aws.sdk.kotlin.services.mediapackagev2.model.EncryptionMethod? = null
        /**
         * The frequency (in seconds) of key changes for live workflows, in which content is streamed real time. The service retrieves content keys before the live content begins streaming, and then retrieves them as needed over the lifetime of the workflow. By default, key rotation is set to 300 seconds (5 minutes), the minimum rotation interval, which is equivalent to setting it to 300. If you don't enter an interval, content keys aren't rotated.
         *
         * The following example setting causes the service to rotate keys every thirty minutes: `1800`
         */
        public var keyRotationIntervalSeconds: kotlin.Int? = null
        /**
         * The parameters for the SPEKE key provider.
         */
        public var spekeKeyProvider: aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackagev2.model.Encryption) : this() {
            this.constantInitializationVector = x.constantInitializationVector
            this.encryptionMethod = x.encryptionMethod
            this.keyRotationIntervalSeconds = x.keyRotationIntervalSeconds
            this.spekeKeyProvider = x.spekeKeyProvider
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackagev2.model.Encryption = Encryption(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.EncryptionMethod] inside the given [block]
         */
        public fun encryptionMethod(block: aws.sdk.kotlin.services.mediapackagev2.model.EncryptionMethod.Builder.() -> kotlin.Unit) {
            this.encryptionMethod = aws.sdk.kotlin.services.mediapackagev2.model.EncryptionMethod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider] inside the given [block]
         */
        public fun spekeKeyProvider(block: aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider.Builder.() -> kotlin.Unit) {
            this.spekeKeyProvider = aws.sdk.kotlin.services.mediapackagev2.model.SpekeKeyProvider.invoke(block)
        }
    }
}
