// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An HTTP Live Streaming (HLS) encryption configuration.
 */
public class HlsEncryption private constructor(builder: Builder) {
    /**
     * A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
     */
    public val constantInitializationVector: kotlin.String? = builder.constantInitializationVector
    /**
     * The encryption method to use.
     */
    public val encryptionMethod: aws.sdk.kotlin.services.mediapackage.model.EncryptionMethod? = builder.encryptionMethod
    /**
     * Interval (in seconds) between each encryption key rotation.
     */
    public val keyRotationIntervalSeconds: kotlin.Int? = builder.keyRotationIntervalSeconds
    /**
     * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
     */
    public val repeatExtXKey: kotlin.Boolean? = builder.repeatExtXKey
    /**
     * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
     */
    public val spekeKeyProvider: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider? = builder.spekeKeyProvider

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.HlsEncryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsEncryption(")
        append("constantInitializationVector=$constantInitializationVector,")
        append("encryptionMethod=$encryptionMethod,")
        append("keyRotationIntervalSeconds=$keyRotationIntervalSeconds,")
        append("repeatExtXKey=$repeatExtXKey,")
        append("spekeKeyProvider=$spekeKeyProvider")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = constantInitializationVector?.hashCode() ?: 0
        result = 31 * result + (encryptionMethod?.hashCode() ?: 0)
        result = 31 * result + (keyRotationIntervalSeconds ?: 0)
        result = 31 * result + (repeatExtXKey?.hashCode() ?: 0)
        result = 31 * result + (spekeKeyProvider?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsEncryption

        if (constantInitializationVector != other.constantInitializationVector) return false
        if (encryptionMethod != other.encryptionMethod) return false
        if (keyRotationIntervalSeconds != other.keyRotationIntervalSeconds) return false
        if (repeatExtXKey != other.repeatExtXKey) return false
        if (spekeKeyProvider != other.spekeKeyProvider) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.HlsEncryption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
         */
        public var constantInitializationVector: kotlin.String? = null
        /**
         * The encryption method to use.
         */
        public var encryptionMethod: aws.sdk.kotlin.services.mediapackage.model.EncryptionMethod? = null
        /**
         * Interval (in seconds) between each encryption key rotation.
         */
        public var keyRotationIntervalSeconds: kotlin.Int? = null
        /**
         * When enabled, the EXT-X-KEY tag will be repeated in output manifests.
         */
        public var repeatExtXKey: kotlin.Boolean? = null
        /**
         * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
         */
        public var spekeKeyProvider: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.HlsEncryption) : this() {
            this.constantInitializationVector = x.constantInitializationVector
            this.encryptionMethod = x.encryptionMethod
            this.keyRotationIntervalSeconds = x.keyRotationIntervalSeconds
            this.repeatExtXKey = x.repeatExtXKey
            this.spekeKeyProvider = x.spekeKeyProvider
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.HlsEncryption = HlsEncryption(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider] inside the given [block]
         */
        public fun spekeKeyProvider(block: aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider.Builder.() -> kotlin.Unit) {
            this.spekeKeyProvider = aws.sdk.kotlin.services.mediapackage.model.SpekeKeyProvider.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
