// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration parameters for where in an S3 bucket to place the harvested content
 */
public class S3Destination private constructor(builder: Builder) {
    /**
     * The name of an S3 bucket within which harvested content will be exported
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The key in the specified S3 bucket where the harvested top-level manifest will be placed.
     */
    public val manifestKey: kotlin.String? = builder.manifestKey
    /**
     * The IAM role used to write to the specified S3 bucket
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.S3Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Destination(")
        append("bucketName=$bucketName,")
        append("manifestKey=$manifestKey,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (manifestKey?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Destination

        if (bucketName != other.bucketName) return false
        if (manifestKey != other.manifestKey) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.S3Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an S3 bucket within which harvested content will be exported
         */
        public var bucketName: kotlin.String? = null
        /**
         * The key in the specified S3 bucket where the harvested top-level manifest will be placed.
         */
        public var manifestKey: kotlin.String? = null
        /**
         * The IAM role used to write to the specified S3 bucket
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.S3Destination) : this() {
            this.bucketName = x.bucketName
            this.manifestKey = x.manifestKey
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.S3Destination = S3Destination(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
