// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration parameters used to update an existing OriginEndpoint.
 */
public class UpdateOriginEndpointRequest private constructor(builder: Builder) {
    /**
     * CDN Authorization credentials
     */
    public val authorization: aws.sdk.kotlin.services.mediapackage.model.Authorization? = builder.authorization
    /**
     * A Common Media Application Format (CMAF) packaging configuration.
     */
    public val cmafPackage: aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters? = builder.cmafPackage
    /**
     * A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
     */
    public val dashPackage: aws.sdk.kotlin.services.mediapackage.model.DashPackage? = builder.dashPackage
    /**
     * A short text description of the OriginEndpoint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An HTTP Live Streaming (HLS) packaging configuration.
     */
    public val hlsPackage: aws.sdk.kotlin.services.mediapackage.model.HlsPackage? = builder.hlsPackage
    /**
     * The ID of the OriginEndpoint to update.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A short string that will be appended to the end of the Endpoint URL.
     */
    public val manifestName: kotlin.String? = builder.manifestName
    /**
     * A Microsoft Smooth Streaming (MSS) packaging configuration.
     */
    public val mssPackage: aws.sdk.kotlin.services.mediapackage.model.MssPackage? = builder.mssPackage
    /**
     * Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
     */
    public val origination: aws.sdk.kotlin.services.mediapackage.model.Origination? = builder.origination
    /**
     * Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
     */
    public val startoverWindowSeconds: kotlin.Int? = builder.startoverWindowSeconds
    /**
     * Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
     */
    public val timeDelaySeconds: kotlin.Int? = builder.timeDelaySeconds
    /**
     * A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
     */
    public val whitelist: List<String>? = builder.whitelist

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOriginEndpointRequest(")
        append("authorization=$authorization,")
        append("cmafPackage=$cmafPackage,")
        append("dashPackage=$dashPackage,")
        append("description=$description,")
        append("hlsPackage=$hlsPackage,")
        append("id=$id,")
        append("manifestName=$manifestName,")
        append("mssPackage=$mssPackage,")
        append("origination=$origination,")
        append("startoverWindowSeconds=$startoverWindowSeconds,")
        append("timeDelaySeconds=$timeDelaySeconds,")
        append("whitelist=$whitelist")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorization?.hashCode() ?: 0
        result = 31 * result + (cmafPackage?.hashCode() ?: 0)
        result = 31 * result + (dashPackage?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hlsPackage?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (manifestName?.hashCode() ?: 0)
        result = 31 * result + (mssPackage?.hashCode() ?: 0)
        result = 31 * result + (origination?.hashCode() ?: 0)
        result = 31 * result + (startoverWindowSeconds ?: 0)
        result = 31 * result + (timeDelaySeconds ?: 0)
        result = 31 * result + (whitelist?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOriginEndpointRequest

        if (authorization != other.authorization) return false
        if (cmafPackage != other.cmafPackage) return false
        if (dashPackage != other.dashPackage) return false
        if (description != other.description) return false
        if (hlsPackage != other.hlsPackage) return false
        if (id != other.id) return false
        if (manifestName != other.manifestName) return false
        if (mssPackage != other.mssPackage) return false
        if (origination != other.origination) return false
        if (startoverWindowSeconds != other.startoverWindowSeconds) return false
        if (timeDelaySeconds != other.timeDelaySeconds) return false
        if (whitelist != other.whitelist) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * CDN Authorization credentials
         */
        public var authorization: aws.sdk.kotlin.services.mediapackage.model.Authorization? = null
        /**
         * A Common Media Application Format (CMAF) packaging configuration.
         */
        public var cmafPackage: aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters? = null
        /**
         * A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
         */
        public var dashPackage: aws.sdk.kotlin.services.mediapackage.model.DashPackage? = null
        /**
         * A short text description of the OriginEndpoint.
         */
        public var description: kotlin.String? = null
        /**
         * An HTTP Live Streaming (HLS) packaging configuration.
         */
        public var hlsPackage: aws.sdk.kotlin.services.mediapackage.model.HlsPackage? = null
        /**
         * The ID of the OriginEndpoint to update.
         */
        public var id: kotlin.String? = null
        /**
         * A short string that will be appended to the end of the Endpoint URL.
         */
        public var manifestName: kotlin.String? = null
        /**
         * A Microsoft Smooth Streaming (MSS) packaging configuration.
         */
        public var mssPackage: aws.sdk.kotlin.services.mediapackage.model.MssPackage? = null
        /**
         * Control whether origination of video is allowed for this OriginEndpoint. If set to ALLOW, the OriginEndpoint may by requested, pursuant to any other form of access control. If set to DENY, the OriginEndpoint may not be requested. This can be helpful for Live to VOD harvesting, or for temporarily disabling origination
         */
        public var origination: aws.sdk.kotlin.services.mediapackage.model.Origination? = null
        /**
         * Maximum duration (in seconds) of content to retain for startover playback. If not specified, startover playback will be disabled for the OriginEndpoint.
         */
        public var startoverWindowSeconds: kotlin.Int? = null
        /**
         * Amount of delay (in seconds) to enforce on the playback of live content. If not specified, there will be no time delay in effect for the OriginEndpoint.
         */
        public var timeDelaySeconds: kotlin.Int? = null
        /**
         * A list of source IP CIDR blocks that will be allowed to access the OriginEndpoint.
         */
        public var whitelist: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointRequest) : this() {
            this.authorization = x.authorization
            this.cmafPackage = x.cmafPackage
            this.dashPackage = x.dashPackage
            this.description = x.description
            this.hlsPackage = x.hlsPackage
            this.id = x.id
            this.manifestName = x.manifestName
            this.mssPackage = x.mssPackage
            this.origination = x.origination
            this.startoverWindowSeconds = x.startoverWindowSeconds
            this.timeDelaySeconds = x.timeDelaySeconds
            this.whitelist = x.whitelist
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointRequest = UpdateOriginEndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.Authorization] inside the given [block]
         */
        public fun authorization(block: aws.sdk.kotlin.services.mediapackage.model.Authorization.Builder.() -> kotlin.Unit) {
            this.authorization = aws.sdk.kotlin.services.mediapackage.model.Authorization.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters] inside the given [block]
         */
        public fun cmafPackage(block: aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters.Builder.() -> kotlin.Unit) {
            this.cmafPackage = aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.DashPackage] inside the given [block]
         */
        public fun dashPackage(block: aws.sdk.kotlin.services.mediapackage.model.DashPackage.Builder.() -> kotlin.Unit) {
            this.dashPackage = aws.sdk.kotlin.services.mediapackage.model.DashPackage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.HlsPackage] inside the given [block]
         */
        public fun hlsPackage(block: aws.sdk.kotlin.services.mediapackage.model.HlsPackage.Builder.() -> kotlin.Unit) {
            this.hlsPackage = aws.sdk.kotlin.services.mediapackage.model.HlsPackage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.MssPackage] inside the given [block]
         */
        public fun mssPackage(block: aws.sdk.kotlin.services.mediapackage.model.MssPackage.Builder.() -> kotlin.Unit) {
            this.mssPackage = aws.sdk.kotlin.services.mediapackage.model.MssPackage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
