// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * A Common Media Application Format (CMAF) packaging configuration.
 */
public class CmafPackage private constructor(builder: Builder) {
    /**
     * A Common Media Application Format (CMAF) encryption configuration.
     */
    public val encryption: aws.sdk.kotlin.services.mediapackage.model.CmafEncryption? = builder.encryption
    /**
     * A list of HLS manifest configurations
     */
    public val hlsManifests: List<HlsManifest>? = builder.hlsManifests
    /**
     * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
     */
    public val segmentDurationSeconds: kotlin.Int? = builder.segmentDurationSeconds
    /**
     * An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
     */
    public val segmentPrefix: kotlin.String? = builder.segmentPrefix
    /**
     * A StreamSelection configuration.
     */
    public val streamSelection: aws.sdk.kotlin.services.mediapackage.model.StreamSelection? = builder.streamSelection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.CmafPackage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CmafPackage(")
        append("encryption=$encryption,")
        append("hlsManifests=$hlsManifests,")
        append("segmentDurationSeconds=$segmentDurationSeconds,")
        append("segmentPrefix=$segmentPrefix,")
        append("streamSelection=$streamSelection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryption?.hashCode() ?: 0
        result = 31 * result + (hlsManifests?.hashCode() ?: 0)
        result = 31 * result + (segmentDurationSeconds ?: 0)
        result = 31 * result + (segmentPrefix?.hashCode() ?: 0)
        result = 31 * result + (streamSelection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CmafPackage

        if (encryption != other.encryption) return false
        if (hlsManifests != other.hlsManifests) return false
        if (segmentDurationSeconds != other.segmentDurationSeconds) return false
        if (segmentPrefix != other.segmentPrefix) return false
        if (streamSelection != other.streamSelection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.CmafPackage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A Common Media Application Format (CMAF) encryption configuration.
         */
        public var encryption: aws.sdk.kotlin.services.mediapackage.model.CmafEncryption? = null
        /**
         * A list of HLS manifest configurations
         */
        public var hlsManifests: List<HlsManifest>? = null
        /**
         * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
         */
        public var segmentDurationSeconds: kotlin.Int? = null
        /**
         * An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
         */
        public var segmentPrefix: kotlin.String? = null
        /**
         * A StreamSelection configuration.
         */
        public var streamSelection: aws.sdk.kotlin.services.mediapackage.model.StreamSelection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.CmafPackage) : this() {
            this.encryption = x.encryption
            this.hlsManifests = x.hlsManifests
            this.segmentDurationSeconds = x.segmentDurationSeconds
            this.segmentPrefix = x.segmentPrefix
            this.streamSelection = x.streamSelection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.CmafPackage = CmafPackage(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.CmafEncryption] inside the given [block]
         */
        public fun encryption(block: aws.sdk.kotlin.services.mediapackage.model.CmafEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediapackage.model.CmafEncryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.StreamSelection] inside the given [block]
         */
        public fun streamSelection(block: aws.sdk.kotlin.services.mediapackage.model.StreamSelection.Builder.() -> kotlin.Unit) {
            this.streamSelection = aws.sdk.kotlin.services.mediapackage.model.StreamSelection.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
