// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.serde

import aws.sdk.kotlin.services.mediapackage.model.Authorization
import aws.sdk.kotlin.services.mediapackage.model.CmafPackageCreateOrUpdateParameters
import aws.sdk.kotlin.services.mediapackage.model.DashPackage
import aws.sdk.kotlin.services.mediapackage.model.HlsPackage
import aws.sdk.kotlin.services.mediapackage.model.MssPackage
import aws.sdk.kotlin.services.mediapackage.model.Origination
import aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateOriginEndpointOperationSerializer: HttpSerialize<UpdateOriginEndpointRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateOriginEndpointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.id) { "id is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("origin_endpoints"))
                add(PercentEncoding.SmithyLabel.encode("${input.id}"))
            }
        }

        val payload = serializeUpdateOriginEndpointOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateOriginEndpointOperationBody(context: ExecutionContext, input: UpdateOriginEndpointRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHORIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authorization"))
    val CMAFPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cmafPackage"))
    val DASHPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dashPackage"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HLSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("hlsPackage"))
    val MANIFESTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("manifestName"))
    val MSSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mssPackage"))
    val ORIGINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("origination"))
    val STARTOVERWINDOWSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("startoverWindowSeconds"))
    val TIMEDELAYSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeDelaySeconds"))
    val WHITELIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("whitelist"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZATION_DESCRIPTOR)
        field(CMAFPACKAGE_DESCRIPTOR)
        field(DASHPACKAGE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HLSPACKAGE_DESCRIPTOR)
        field(MANIFESTNAME_DESCRIPTOR)
        field(MSSPACKAGE_DESCRIPTOR)
        field(ORIGINATION_DESCRIPTOR)
        field(STARTOVERWINDOWSECONDS_DESCRIPTOR)
        field(TIMEDELAYSECONDS_DESCRIPTOR)
        field(WHITELIST_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authorization?.let { field(AUTHORIZATION_DESCRIPTOR, it, ::serializeAuthorizationDocument) }
        input.cmafPackage?.let { field(CMAFPACKAGE_DESCRIPTOR, it, ::serializeCmafPackageCreateOrUpdateParametersDocument) }
        input.dashPackage?.let { field(DASHPACKAGE_DESCRIPTOR, it, ::serializeDashPackageDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.hlsPackage?.let { field(HLSPACKAGE_DESCRIPTOR, it, ::serializeHlsPackageDocument) }
        input.manifestName?.let { field(MANIFESTNAME_DESCRIPTOR, it) }
        input.mssPackage?.let { field(MSSPACKAGE_DESCRIPTOR, it, ::serializeMssPackageDocument) }
        input.origination?.let { field(ORIGINATION_DESCRIPTOR, it.value) }
        input.startoverWindowSeconds?.let { field(STARTOVERWINDOWSECONDS_DESCRIPTOR, it) }
        input.timeDelaySeconds?.let { field(TIMEDELAYSECONDS_DESCRIPTOR, it) }
        if (input.whitelist != null) {
            listField(WHITELIST_DESCRIPTOR) {
                for (el0 in input.whitelist) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
