// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.serde

import aws.sdk.kotlin.services.mediapackage.model.Authorization
import aws.sdk.kotlin.services.mediapackage.model.CmafPackage
import aws.sdk.kotlin.services.mediapackage.model.DashPackage
import aws.sdk.kotlin.services.mediapackage.model.DescribeOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.HlsPackage
import aws.sdk.kotlin.services.mediapackage.model.MediaPackageException
import aws.sdk.kotlin.services.mediapackage.model.MssPackage
import aws.sdk.kotlin.services.mediapackage.model.Origination
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeOriginEndpointOperationDeserializer: HttpDeserialize<DescribeOriginEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeOriginEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeOriginEndpointError(context, call)
        }
        val builder = DescribeOriginEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOriginEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeOriginEndpointError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MediaPackageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "UnprocessableEntityException" -> UnprocessableEntityExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MediaPackageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOriginEndpointOperationBody(builder: DescribeOriginEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AUTHORIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("authorization"))
    val CHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelId"))
    val CMAFPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cmafPackage"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdAt"))
    val DASHPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dashPackage"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HLSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("hlsPackage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MANIFESTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("manifestName"))
    val MSSPACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("mssPackage"))
    val ORIGINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("origination"))
    val STARTOVERWINDOWSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("startoverWindowSeconds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TIMEDELAYSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeDelaySeconds"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("url"))
    val WHITELIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("whitelist"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(AUTHORIZATION_DESCRIPTOR)
        field(CHANNELID_DESCRIPTOR)
        field(CMAFPACKAGE_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DASHPACKAGE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HLSPACKAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MANIFESTNAME_DESCRIPTOR)
        field(MSSPACKAGE_DESCRIPTOR)
        field(ORIGINATION_DESCRIPTOR)
        field(STARTOVERWINDOWSECONDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEDELAYSECONDS_DESCRIPTOR)
        field(URL_DESCRIPTOR)
        field(WHITELIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTHORIZATION_DESCRIPTOR.index -> builder.authorization = deserializeAuthorizationDocument(deserializer)
                CHANNELID_DESCRIPTOR.index -> builder.channelId = deserializeString()
                CMAFPACKAGE_DESCRIPTOR.index -> builder.cmafPackage = deserializeCmafPackageDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString()
                DASHPACKAGE_DESCRIPTOR.index -> builder.dashPackage = deserializeDashPackageDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HLSPACKAGE_DESCRIPTOR.index -> builder.hlsPackage = deserializeHlsPackageDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MANIFESTNAME_DESCRIPTOR.index -> builder.manifestName = deserializeString()
                MSSPACKAGE_DESCRIPTOR.index -> builder.mssPackage = deserializeMssPackageDocument(deserializer)
                ORIGINATION_DESCRIPTOR.index -> builder.origination = deserializeString().let { Origination.fromValue(it) }
                STARTOVERWINDOWSECONDS_DESCRIPTOR.index -> builder.startoverWindowSeconds = deserializeInt()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TIMEDELAYSECONDS_DESCRIPTOR.index -> builder.timeDelaySeconds = deserializeInt()
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                WHITELIST_DESCRIPTOR.index -> builder.whitelist =
                    deserializer.deserializeList(WHITELIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
