// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.mediapackage.auth.DefaultMediaPackageAuthSchemeProvider
import aws.sdk.kotlin.services.mediapackage.auth.MediaPackageAuthSchemeProvider
import aws.sdk.kotlin.services.mediapackage.endpoints.DefaultMediaPackageEndpointProvider
import aws.sdk.kotlin.services.mediapackage.endpoints.MediaPackageEndpointParameters
import aws.sdk.kotlin.services.mediapackage.endpoints.MediaPackageEndpointProvider
import aws.sdk.kotlin.services.mediapackage.model.ConfigureLogsRequest
import aws.sdk.kotlin.services.mediapackage.model.ConfigureLogsResponse
import aws.sdk.kotlin.services.mediapackage.model.CreateChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.CreateChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.CreateHarvestJobRequest
import aws.sdk.kotlin.services.mediapackage.model.CreateHarvestJobResponse
import aws.sdk.kotlin.services.mediapackage.model.CreateOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.CreateOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.DeleteChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.DeleteChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.DeleteOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.DeleteOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.DescribeChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.DescribeChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.DescribeHarvestJobRequest
import aws.sdk.kotlin.services.mediapackage.model.DescribeHarvestJobResponse
import aws.sdk.kotlin.services.mediapackage.model.DescribeOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.DescribeOriginEndpointResponse
import aws.sdk.kotlin.services.mediapackage.model.ListChannelsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListChannelsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListHarvestJobsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListHarvestJobsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListOriginEndpointsRequest
import aws.sdk.kotlin.services.mediapackage.model.ListOriginEndpointsResponse
import aws.sdk.kotlin.services.mediapackage.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediapackage.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediapackage.model.RotateChannelCredentialsRequest
import aws.sdk.kotlin.services.mediapackage.model.RotateChannelCredentialsResponse
import aws.sdk.kotlin.services.mediapackage.model.RotateIngestEndpointCredentialsRequest
import aws.sdk.kotlin.services.mediapackage.model.RotateIngestEndpointCredentialsResponse
import aws.sdk.kotlin.services.mediapackage.model.TagResourceRequest
import aws.sdk.kotlin.services.mediapackage.model.TagResourceResponse
import aws.sdk.kotlin.services.mediapackage.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediapackage.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediapackage.model.UpdateChannelRequest
import aws.sdk.kotlin.services.mediapackage.model.UpdateChannelResponse
import aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointRequest
import aws.sdk.kotlin.services.mediapackage.model.UpdateOriginEndpointResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "MediaPackage"
public const val SdkVersion: String = "1.0.33"
public const val ServiceApiVersion: String = "2017-10-12"

/**
 * AWS Elemental MediaPackage
 */
public interface MediaPackageClient : SdkClient {
    /**
     * MediaPackageClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MediaPackageClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MediaPackage",
                "MEDIAPACKAGE",
                "mediapackage",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MediaPackageClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MediaPackageClient = DefaultMediaPackageClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MediaPackageEndpointProvider = builder.endpointProvider ?: DefaultMediaPackageEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MediaPackageAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMediaPackageAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MediaPackage"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MediaPackageEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MediaPackageAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Changes the Channel's properities to configure log subscription
     */
    public suspend fun configureLogs(input: ConfigureLogsRequest): ConfigureLogsResponse

    /**
     * Creates a new Channel.
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Creates a new HarvestJob record.
     */
    public suspend fun createHarvestJob(input: CreateHarvestJobRequest): CreateHarvestJobResponse

    /**
     * Creates a new OriginEndpoint record.
     */
    public suspend fun createOriginEndpoint(input: CreateOriginEndpointRequest): CreateOriginEndpointResponse

    /**
     * Deletes an existing Channel.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes an existing OriginEndpoint.
     */
    public suspend fun deleteOriginEndpoint(input: DeleteOriginEndpointRequest): DeleteOriginEndpointResponse

    /**
     * Gets details about a Channel.
     */
    public suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Gets details about an existing HarvestJob.
     */
    public suspend fun describeHarvestJob(input: DescribeHarvestJobRequest): DescribeHarvestJobResponse

    /**
     * Gets details about an existing OriginEndpoint.
     */
    public suspend fun describeOriginEndpoint(input: DescribeOriginEndpointRequest): DescribeOriginEndpointResponse

    /**
     * Returns a collection of Channels.
     */
    public suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest { }): ListChannelsResponse

    /**
     * Returns a collection of HarvestJob records.
     */
    public suspend fun listHarvestJobs(input: ListHarvestJobsRequest = ListHarvestJobsRequest { }): ListHarvestJobsResponse

    /**
     * Returns a collection of OriginEndpoint records.
     */
    public suspend fun listOriginEndpoints(input: ListOriginEndpointsRequest = ListOriginEndpointsRequest { }): ListOriginEndpointsResponse

    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun rotateChannelCredentials(input: RotateChannelCredentialsRequest): RotateChannelCredentialsResponse

    /**
     * Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
     */
    public suspend fun rotateIngestEndpointCredentials(input: RotateIngestEndpointCredentialsRequest): RotateIngestEndpointCredentialsResponse

    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Channel.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates an existing OriginEndpoint.
     */
    public suspend fun updateOriginEndpoint(input: UpdateOriginEndpointRequest): UpdateOriginEndpointResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MediaPackageClient.withConfig(block: MediaPackageClient.Config.Builder.() -> Unit): MediaPackageClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMediaPackageClient(newConfig)
}

/**
 * Changes the Channel's properities to configure log subscription
 */
public suspend inline fun MediaPackageClient.configureLogs(crossinline block: ConfigureLogsRequest.Builder.() -> Unit): ConfigureLogsResponse = configureLogs(ConfigureLogsRequest.Builder().apply(block).build())

/**
 * Creates a new Channel.
 */
public suspend inline fun MediaPackageClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Creates a new HarvestJob record.
 */
public suspend inline fun MediaPackageClient.createHarvestJob(crossinline block: CreateHarvestJobRequest.Builder.() -> Unit): CreateHarvestJobResponse = createHarvestJob(CreateHarvestJobRequest.Builder().apply(block).build())

/**
 * Creates a new OriginEndpoint record.
 */
public suspend inline fun MediaPackageClient.createOriginEndpoint(crossinline block: CreateOriginEndpointRequest.Builder.() -> Unit): CreateOriginEndpointResponse = createOriginEndpoint(CreateOriginEndpointRequest.Builder().apply(block).build())

/**
 * Deletes an existing Channel.
 */
public suspend inline fun MediaPackageClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes an existing OriginEndpoint.
 */
public suspend inline fun MediaPackageClient.deleteOriginEndpoint(crossinline block: DeleteOriginEndpointRequest.Builder.() -> Unit): DeleteOriginEndpointResponse = deleteOriginEndpoint(DeleteOriginEndpointRequest.Builder().apply(block).build())

/**
 * Gets details about a Channel.
 */
public suspend inline fun MediaPackageClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit): DescribeChannelResponse = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Gets details about an existing HarvestJob.
 */
public suspend inline fun MediaPackageClient.describeHarvestJob(crossinline block: DescribeHarvestJobRequest.Builder.() -> Unit): DescribeHarvestJobResponse = describeHarvestJob(DescribeHarvestJobRequest.Builder().apply(block).build())

/**
 * Gets details about an existing OriginEndpoint.
 */
public suspend inline fun MediaPackageClient.describeOriginEndpoint(crossinline block: DescribeOriginEndpointRequest.Builder.() -> Unit): DescribeOriginEndpointResponse = describeOriginEndpoint(DescribeOriginEndpointRequest.Builder().apply(block).build())

/**
 * Returns a collection of Channels.
 */
public suspend inline fun MediaPackageClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Returns a collection of HarvestJob records.
 */
public suspend inline fun MediaPackageClient.listHarvestJobs(crossinline block: ListHarvestJobsRequest.Builder.() -> Unit): ListHarvestJobsResponse = listHarvestJobs(ListHarvestJobsRequest.Builder().apply(block).build())

/**
 * Returns a collection of OriginEndpoint records.
 */
public suspend inline fun MediaPackageClient.listOriginEndpoints(crossinline block: ListOriginEndpointsRequest.Builder.() -> Unit): ListOriginEndpointsResponse = listOriginEndpoints(ListOriginEndpointsRequest.Builder().apply(block).build())

public suspend inline fun MediaPackageClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Changes the Channel's first IngestEndpoint's username and password. WARNING - This API is deprecated. Please use RotateIngestEndpointCredentials instead
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun MediaPackageClient.rotateChannelCredentials(crossinline block: RotateChannelCredentialsRequest.Builder.() -> Unit): RotateChannelCredentialsResponse = rotateChannelCredentials(RotateChannelCredentialsRequest.Builder().apply(block).build())

/**
 * Rotate the IngestEndpoint's username and password, as specified by the IngestEndpoint's id.
 */
public suspend inline fun MediaPackageClient.rotateIngestEndpointCredentials(crossinline block: RotateIngestEndpointCredentialsRequest.Builder.() -> Unit): RotateIngestEndpointCredentialsResponse = rotateIngestEndpointCredentials(RotateIngestEndpointCredentialsRequest.Builder().apply(block).build())

public suspend inline fun MediaPackageClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

public suspend inline fun MediaPackageClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Channel.
 */
public suspend inline fun MediaPackageClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates an existing OriginEndpoint.
 */
public suspend inline fun MediaPackageClient.updateOriginEndpoint(crossinline block: UpdateOriginEndpointRequest.Builder.() -> Unit): UpdateOriginEndpointResponse = updateOriginEndpoint(UpdateOriginEndpointRequest.Builder().apply(block).build())
