// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediapackage.model



/**
 * An HTTP Live Streaming (HLS) packaging configuration.
 */
class HlsPackage private constructor(builder: Builder) {
    /**
     * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
     */
    val adMarkers: aws.sdk.kotlin.services.mediapackage.model.AdMarkers? = builder.adMarkers
    /**
     * A list of SCTE-35 message types that are treated as ad markers in the output. If empty, no ad markers are output. Specify multiple items to create ad markers for all of the included message types.
     */
    val adTriggers: List<AdTriggersElement>? = builder.adTriggers
    /**
     * This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to determine whether a message signals an ad. Choosing "NONE" means no SCTE-35 messages become ads. Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that contain delivery restrictions will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that do not contain delivery restrictions will be treated as ads. Choosing "BOTH" means all SCTE-35 messages of the types specified in AdTriggers will be treated as ads. Note that Splice Insert messages do not have these flags and are always treated as ads if specified in AdTriggers.
     */
    val adsOnDeliveryRestrictions: aws.sdk.kotlin.services.mediapackage.model.AdsOnDeliveryRestrictions? = builder.adsOnDeliveryRestrictions
    /**
     * An HTTP Live Streaming (HLS) encryption configuration.
     */
    val encryption: aws.sdk.kotlin.services.mediapackage.model.HlsEncryption? = builder.encryption
    /**
     * When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
     */
    val includeDvbSubtitles: kotlin.Boolean? = builder.includeDvbSubtitles
    /**
     * When enabled, an I-Frame only stream will be included in the output.
     */
    val includeIframeOnlyStream: kotlin.Boolean? = builder.includeIframeOnlyStream
    /**
     * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
     */
    val playlistType: aws.sdk.kotlin.services.mediapackage.model.PlaylistType? = builder.playlistType
    /**
     * Time window (in seconds) contained in each parent manifest.
     */
    val playlistWindowSeconds: kotlin.Int? = builder.playlistWindowSeconds
    /**
     * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
     */
    val programDateTimeIntervalSeconds: kotlin.Int? = builder.programDateTimeIntervalSeconds
    /**
     * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
     */
    val segmentDurationSeconds: kotlin.Int? = builder.segmentDurationSeconds
    /**
     * A StreamSelection configuration.
     */
    val streamSelection: aws.sdk.kotlin.services.mediapackage.model.StreamSelection? = builder.streamSelection
    /**
     * When enabled, audio streams will be placed in rendition groups in the output.
     */
    val useAudioRenditionGroup: kotlin.Boolean? = builder.useAudioRenditionGroup

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediapackage.model.HlsPackage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsPackage(")
        append("adMarkers=$adMarkers,")
        append("adTriggers=$adTriggers,")
        append("adsOnDeliveryRestrictions=$adsOnDeliveryRestrictions,")
        append("encryption=$encryption,")
        append("includeDvbSubtitles=$includeDvbSubtitles,")
        append("includeIframeOnlyStream=$includeIframeOnlyStream,")
        append("playlistType=$playlistType,")
        append("playlistWindowSeconds=$playlistWindowSeconds,")
        append("programDateTimeIntervalSeconds=$programDateTimeIntervalSeconds,")
        append("segmentDurationSeconds=$segmentDurationSeconds,")
        append("streamSelection=$streamSelection,")
        append("useAudioRenditionGroup=$useAudioRenditionGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adMarkers?.hashCode() ?: 0
        result = 31 * result + (adTriggers?.hashCode() ?: 0)
        result = 31 * result + (adsOnDeliveryRestrictions?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (includeDvbSubtitles?.hashCode() ?: 0)
        result = 31 * result + (includeIframeOnlyStream?.hashCode() ?: 0)
        result = 31 * result + (playlistType?.hashCode() ?: 0)
        result = 31 * result + (playlistWindowSeconds ?: 0)
        result = 31 * result + (programDateTimeIntervalSeconds ?: 0)
        result = 31 * result + (segmentDurationSeconds ?: 0)
        result = 31 * result + (streamSelection?.hashCode() ?: 0)
        result = 31 * result + (useAudioRenditionGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsPackage

        if (adMarkers != other.adMarkers) return false
        if (adTriggers != other.adTriggers) return false
        if (adsOnDeliveryRestrictions != other.adsOnDeliveryRestrictions) return false
        if (encryption != other.encryption) return false
        if (includeDvbSubtitles != other.includeDvbSubtitles) return false
        if (includeIframeOnlyStream != other.includeIframeOnlyStream) return false
        if (playlistType != other.playlistType) return false
        if (playlistWindowSeconds != other.playlistWindowSeconds) return false
        if (programDateTimeIntervalSeconds != other.programDateTimeIntervalSeconds) return false
        if (segmentDurationSeconds != other.segmentDurationSeconds) return false
        if (streamSelection != other.streamSelection) return false
        if (useAudioRenditionGroup != other.useAudioRenditionGroup) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediapackage.model.HlsPackage = Builder(this).apply(block).build()

    class Builder {
        /**
         * This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
         */
        var adMarkers: aws.sdk.kotlin.services.mediapackage.model.AdMarkers? = null
        /**
         * A list of SCTE-35 message types that are treated as ad markers in the output. If empty, no ad markers are output. Specify multiple items to create ad markers for all of the included message types.
         */
        var adTriggers: List<AdTriggersElement>? = null
        /**
         * This setting allows the delivery restriction flags on SCTE-35 segmentation descriptors to determine whether a message signals an ad. Choosing "NONE" means no SCTE-35 messages become ads. Choosing "RESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that contain delivery restrictions will be treated as ads. Choosing "UNRESTRICTED" means SCTE-35 messages of the types specified in AdTriggers that do not contain delivery restrictions will be treated as ads. Choosing "BOTH" means all SCTE-35 messages of the types specified in AdTriggers will be treated as ads. Note that Splice Insert messages do not have these flags and are always treated as ads if specified in AdTriggers.
         */
        var adsOnDeliveryRestrictions: aws.sdk.kotlin.services.mediapackage.model.AdsOnDeliveryRestrictions? = null
        /**
         * An HTTP Live Streaming (HLS) encryption configuration.
         */
        var encryption: aws.sdk.kotlin.services.mediapackage.model.HlsEncryption? = null
        /**
         * When enabled, MediaPackage passes through digital video broadcasting (DVB) subtitles into the output.
         */
        var includeDvbSubtitles: kotlin.Boolean? = null
        /**
         * When enabled, an I-Frame only stream will be included in the output.
         */
        var includeIframeOnlyStream: kotlin.Boolean? = null
        /**
         * The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
         */
        var playlistType: aws.sdk.kotlin.services.mediapackage.model.PlaylistType? = null
        /**
         * Time window (in seconds) contained in each parent manifest.
         */
        var playlistWindowSeconds: kotlin.Int? = null
        /**
         * The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
         */
        var programDateTimeIntervalSeconds: kotlin.Int? = null
        /**
         * Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
         */
        var segmentDurationSeconds: kotlin.Int? = null
        /**
         * A StreamSelection configuration.
         */
        var streamSelection: aws.sdk.kotlin.services.mediapackage.model.StreamSelection? = null
        /**
         * When enabled, audio streams will be placed in rendition groups in the output.
         */
        var useAudioRenditionGroup: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediapackage.model.HlsPackage) : this() {
            this.adMarkers = x.adMarkers
            this.adTriggers = x.adTriggers
            this.adsOnDeliveryRestrictions = x.adsOnDeliveryRestrictions
            this.encryption = x.encryption
            this.includeDvbSubtitles = x.includeDvbSubtitles
            this.includeIframeOnlyStream = x.includeIframeOnlyStream
            this.playlistType = x.playlistType
            this.playlistWindowSeconds = x.playlistWindowSeconds
            this.programDateTimeIntervalSeconds = x.programDateTimeIntervalSeconds
            this.segmentDurationSeconds = x.segmentDurationSeconds
            this.streamSelection = x.streamSelection
            this.useAudioRenditionGroup = x.useAudioRenditionGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediapackage.model.HlsPackage = HlsPackage(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.HlsEncryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediapackage.model.HlsEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediapackage.model.HlsEncryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediapackage.model.StreamSelection] inside the given [block]
         */
        fun streamSelection(block: aws.sdk.kotlin.services.mediapackage.model.StreamSelection.Builder.() -> kotlin.Unit) {
            this.streamSelection = aws.sdk.kotlin.services.mediapackage.model.StreamSelection.invoke(block)
        }
    }
}
