// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mediaconnect.model.MediaConnectException
import aws.sdk.kotlin.services.mediaconnect.model.RevokeFlowEntitlementResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RevokeFlowEntitlementOperationDeserializer: HttpDeserialize<RevokeFlowEntitlementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RevokeFlowEntitlementResponse {
        if (!response.status.isSuccess()) {
            throwRevokeFlowEntitlementError(context, response)
        }
        val builder = RevokeFlowEntitlementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRevokeFlowEntitlementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeRevokeFlowEntitlementOperationBody(builder: RevokeFlowEntitlementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITLEMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entitlementArn"))
    val FLOWARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("flowArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITLEMENTARN_DESCRIPTOR)
        field(FLOWARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITLEMENTARN_DESCRIPTOR.index -> builder.entitlementArn = deserializeString()
                FLOWARN_DESCRIPTOR.index -> builder.flowArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwRevokeFlowEntitlementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        else -> throw MediaConnectException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
