// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The fields that you want to update in the output.
 */
class UpdateFlowOutputRequest private constructor(builder: Builder) {
    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val cidrAllowList: List<String>? = builder.cidrAllowList
    /**
     * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
     */
    val description: kotlin.String? = builder.description
    /**
     * The IP address where you want to send the output.
     */
    val destination: kotlin.String? = builder.destination
    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    val encryption: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption? = builder.encryption
    /**
     * The flow that is associated with the output that you want to update.
     */
    val flowArn: kotlin.String? = builder.flowArn
    /**
     * The maximum latency in milliseconds for Zixi-based streams.
     */
    val maxLatency: kotlin.Int? = builder.maxLatency
    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     */
    val mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = builder.mediaStreamOutputConfigurations
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    val minLatency: kotlin.Int? = builder.minLatency
    /**
     * The ARN of the output that you want to update.
     */
    val outputArn: kotlin.String? = builder.outputArn
    /**
     * The port to use when content is distributed to this output.
     */
    val port: kotlin.Int? = builder.port
    /**
     * The protocol to use for the output.
     */
    val protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = builder.protocol
    /**
     * The remote ID for the Zixi-pull stream.
     */
    val remoteId: kotlin.String? = builder.remoteId
    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    val smoothingLatency: kotlin.Int? = builder.smoothingLatency
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    val streamId: kotlin.String? = builder.streamId
    /**
     * The name of the VPC interface attachment to use for this output.
     */
    val vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = builder.vpcInterfaceAttachment

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowOutputRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFlowOutputRequest(")
        append("cidrAllowList=$cidrAllowList,")
        append("description=$description,")
        append("destination=$destination,")
        append("encryption=$encryption,")
        append("flowArn=$flowArn,")
        append("maxLatency=$maxLatency,")
        append("mediaStreamOutputConfigurations=$mediaStreamOutputConfigurations,")
        append("minLatency=$minLatency,")
        append("outputArn=$outputArn,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("remoteId=$remoteId,")
        append("smoothingLatency=$smoothingLatency,")
        append("streamId=$streamId,")
        append("vpcInterfaceAttachment=$vpcInterfaceAttachment)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrAllowList?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (mediaStreamOutputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (outputArn?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (remoteId?.hashCode() ?: 0)
        result = 31 * result + (smoothingLatency ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceAttachment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFlowOutputRequest

        if (cidrAllowList != other.cidrAllowList) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (encryption != other.encryption) return false
        if (flowArn != other.flowArn) return false
        if (maxLatency != other.maxLatency) return false
        if (mediaStreamOutputConfigurations != other.mediaStreamOutputConfigurations) return false
        if (minLatency != other.minLatency) return false
        if (outputArn != other.outputArn) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (remoteId != other.remoteId) return false
        if (smoothingLatency != other.smoothingLatency) return false
        if (streamId != other.streamId) return false
        if (vpcInterfaceAttachment != other.vpcInterfaceAttachment) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowOutputRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var cidrAllowList: List<String>? = null
        /**
         * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
         */
        var description: kotlin.String? = null
        /**
         * The IP address where you want to send the output.
         */
        var destination: kotlin.String? = null
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        var encryption: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption? = null
        /**
         * The flow that is associated with the output that you want to update.
         */
        var flowArn: kotlin.String? = null
        /**
         * The maximum latency in milliseconds for Zixi-based streams.
         */
        var maxLatency: kotlin.Int? = null
        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         */
        var mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = null
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        var minLatency: kotlin.Int? = null
        /**
         * The ARN of the output that you want to update.
         */
        var outputArn: kotlin.String? = null
        /**
         * The port to use when content is distributed to this output.
         */
        var port: kotlin.Int? = null
        /**
         * The protocol to use for the output.
         */
        var protocol: aws.sdk.kotlin.services.mediaconnect.model.Protocol? = null
        /**
         * The remote ID for the Zixi-pull stream.
         */
        var remoteId: kotlin.String? = null
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        var smoothingLatency: kotlin.Int? = null
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        var streamId: kotlin.String? = null
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        var vpcInterfaceAttachment: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowOutputRequest) : this() {
            this.cidrAllowList = x.cidrAllowList
            this.description = x.description
            this.destination = x.destination
            this.encryption = x.encryption
            this.flowArn = x.flowArn
            this.maxLatency = x.maxLatency
            this.mediaStreamOutputConfigurations = x.mediaStreamOutputConfigurations
            this.minLatency = x.minLatency
            this.outputArn = x.outputArn
            this.port = x.port
            this.protocol = x.protocol
            this.remoteId = x.remoteId
            this.smoothingLatency = x.smoothingLatency
            this.streamId = x.streamId
            this.vpcInterfaceAttachment = x.vpcInterfaceAttachment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowOutputRequest = UpdateFlowOutputRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment] inside the given [block]
         */
        fun vpcInterfaceAttachment(block: aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.Builder.() -> kotlin.Unit) {
            this.vpcInterfaceAttachment = aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment.invoke(block)
        }
    }
}
