// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for the source of the flow.
 */
class Source private constructor(builder: Builder) {
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    val dataTransferSubscriberFeePercent: kotlin.Int? = builder.dataTransferSubscriberFeePercent
    /**
     * The type of encryption that is used on the content ingested from this source.
     */
    val decryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = builder.decryption
    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
     */
    val entitlementArn: kotlin.String? = builder.entitlementArn
    /**
     * The IP address that the flow will be listening on for incoming content.
     */
    val ingestIp: kotlin.String? = builder.ingestIp
    /**
     * The port that the flow will be listening on for incoming content.
     */
    val ingestPort: kotlin.Int? = builder.ingestPort
    /**
     * The media streams that are associated with the source, and the parameters for those associations.
     */
    val mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>? = builder.mediaStreamSourceConfigurations
    /**
     * The name of the source.
     */
    val name: kotlin.String? = builder.name
    /**
     * The ARN of the source.
     */
    val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * Attributes related to the transport stream that are used in the source.
     */
    val transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = builder.transport
    /**
     * The name of the VPC interface that is used for this source.
     */
    val vpcInterfaceName: kotlin.String? = builder.vpcInterfaceName
    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val whitelistCidr: kotlin.String? = builder.whitelistCidr

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Source = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Source(")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("decryption=$decryption,")
        append("description=$description,")
        append("entitlementArn=$entitlementArn,")
        append("ingestIp=$ingestIp,")
        append("ingestPort=$ingestPort,")
        append("mediaStreamSourceConfigurations=$mediaStreamSourceConfigurations,")
        append("name=$name,")
        append("sourceArn=$sourceArn,")
        append("transport=$transport,")
        append("vpcInterfaceName=$vpcInterfaceName,")
        append("whitelistCidr=$whitelistCidr)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferSubscriberFeePercent ?: 0
        result = 31 * result + (decryption?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (ingestIp?.hashCode() ?: 0)
        result = 31 * result + (ingestPort ?: 0)
        result = 31 * result + (mediaStreamSourceConfigurations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (transport?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (whitelistCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Source

        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (decryption != other.decryption) return false
        if (description != other.description) return false
        if (entitlementArn != other.entitlementArn) return false
        if (ingestIp != other.ingestIp) return false
        if (ingestPort != other.ingestPort) return false
        if (mediaStreamSourceConfigurations != other.mediaStreamSourceConfigurations) return false
        if (name != other.name) return false
        if (sourceArn != other.sourceArn) return false
        if (transport != other.transport) return false
        if (vpcInterfaceName != other.vpcInterfaceName) return false
        if (whitelistCidr != other.whitelistCidr) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Source = Builder(this).apply(block).build()

    class Builder {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        var dataTransferSubscriberFeePercent: kotlin.Int? = null
        /**
         * The type of encryption that is used on the content ingested from this source.
         */
        var decryption: aws.sdk.kotlin.services.mediaconnect.model.Encryption? = null
        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        var description: kotlin.String? = null
        /**
         * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
         */
        var entitlementArn: kotlin.String? = null
        /**
         * The IP address that the flow will be listening on for incoming content.
         */
        var ingestIp: kotlin.String? = null
        /**
         * The port that the flow will be listening on for incoming content.
         */
        var ingestPort: kotlin.Int? = null
        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         */
        var mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>? = null
        /**
         * The name of the source.
         */
        var name: kotlin.String? = null
        /**
         * The ARN of the source.
         */
        var sourceArn: kotlin.String? = null
        /**
         * Attributes related to the transport stream that are used in the source.
         */
        var transport: aws.sdk.kotlin.services.mediaconnect.model.Transport? = null
        /**
         * The name of the VPC interface that is used for this source.
         */
        var vpcInterfaceName: kotlin.String? = null
        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var whitelistCidr: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Source) : this() {
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.decryption = x.decryption
            this.description = x.description
            this.entitlementArn = x.entitlementArn
            this.ingestIp = x.ingestIp
            this.ingestPort = x.ingestPort
            this.mediaStreamSourceConfigurations = x.mediaStreamSourceConfigurations
            this.name = x.name
            this.sourceArn = x.sourceArn
            this.transport = x.transport
            this.vpcInterfaceName = x.vpcInterfaceName
            this.whitelistCidr = x.whitelistCidr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Source = Source(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        fun decryption(block: aws.sdk.kotlin.services.mediaconnect.model.Encryption.Builder.() -> kotlin.Unit) {
            this.decryption = aws.sdk.kotlin.services.mediaconnect.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Transport] inside the given [block]
         */
        fun transport(block: aws.sdk.kotlin.services.mediaconnect.model.Transport.Builder.() -> kotlin.Unit) {
            this.transport = aws.sdk.kotlin.services.mediaconnect.model.Transport.invoke(block)
        }
    }
}
