// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
 */
class Reservation private constructor(builder: Builder) {
    /**
     * The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
     */
    val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The length of time that this reservation is active. MediaConnect defines this value in the offering.
     */
    val duration: kotlin.Int? = builder.duration
    /**
     * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
     */
    val durationUnits: aws.sdk.kotlin.services.mediaconnect.model.DurationUnits? = builder.durationUnits
    /**
     * The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
     */
    val end: kotlin.String? = builder.end
    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     */
    val offeringArn: kotlin.String? = builder.offeringArn
    /**
     * A description of the offering. MediaConnect defines this value in the offering.
     */
    val offeringDescription: kotlin.String? = builder.offeringDescription
    /**
     * The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
     */
    val pricePerUnit: kotlin.String? = builder.pricePerUnit
    /**
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
     */
    val priceUnits: aws.sdk.kotlin.services.mediaconnect.model.PriceUnits? = builder.priceUnits
    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
     */
    val reservationArn: kotlin.String? = builder.reservationArn
    /**
     * The name that you assigned to the reservation when you purchased the offering.
     */
    val reservationName: kotlin.String? = builder.reservationName
    /**
     * The status of your reservation.
     */
    val reservationState: aws.sdk.kotlin.services.mediaconnect.model.ReservationState? = builder.reservationState
    /**
     * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
     */
    val resourceSpecification: aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification? = builder.resourceSpecification
    /**
     * The day and time that the reservation becomes active. You set this value when you purchase the offering.
     */
    val start: kotlin.String? = builder.start

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Reservation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Reservation(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("durationUnits=$durationUnits,")
        append("end=$end,")
        append("offeringArn=$offeringArn,")
        append("offeringDescription=$offeringDescription,")
        append("pricePerUnit=$pricePerUnit,")
        append("priceUnits=$priceUnits,")
        append("reservationArn=$reservationArn,")
        append("reservationName=$reservationName,")
        append("reservationState=$reservationState,")
        append("resourceSpecification=$resourceSpecification,")
        append("start=$start)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (durationUnits?.hashCode() ?: 0)
        result = 31 * result + (end?.hashCode() ?: 0)
        result = 31 * result + (offeringArn?.hashCode() ?: 0)
        result = 31 * result + (offeringDescription?.hashCode() ?: 0)
        result = 31 * result + (pricePerUnit?.hashCode() ?: 0)
        result = 31 * result + (priceUnits?.hashCode() ?: 0)
        result = 31 * result + (reservationArn?.hashCode() ?: 0)
        result = 31 * result + (reservationName?.hashCode() ?: 0)
        result = 31 * result + (reservationState?.hashCode() ?: 0)
        result = 31 * result + (resourceSpecification?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Reservation

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (durationUnits != other.durationUnits) return false
        if (end != other.end) return false
        if (offeringArn != other.offeringArn) return false
        if (offeringDescription != other.offeringDescription) return false
        if (pricePerUnit != other.pricePerUnit) return false
        if (priceUnits != other.priceUnits) return false
        if (reservationArn != other.reservationArn) return false
        if (reservationName != other.reservationName) return false
        if (reservationState != other.reservationState) return false
        if (resourceSpecification != other.resourceSpecification) return false
        if (start != other.start) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Reservation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
         */
        var currencyCode: kotlin.String? = null
        /**
         * The length of time that this reservation is active. MediaConnect defines this value in the offering.
         */
        var duration: kotlin.Int? = null
        /**
         * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
         */
        var durationUnits: aws.sdk.kotlin.services.mediaconnect.model.DurationUnits? = null
        /**
         * The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
         */
        var end: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         */
        var offeringArn: kotlin.String? = null
        /**
         * A description of the offering. MediaConnect defines this value in the offering.
         */
        var offeringDescription: kotlin.String? = null
        /**
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
         */
        var pricePerUnit: kotlin.String? = null
        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
         */
        var priceUnits: aws.sdk.kotlin.services.mediaconnect.model.PriceUnits? = null
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
         */
        var reservationArn: kotlin.String? = null
        /**
         * The name that you assigned to the reservation when you purchased the offering.
         */
        var reservationName: kotlin.String? = null
        /**
         * The status of your reservation.
         */
        var reservationState: aws.sdk.kotlin.services.mediaconnect.model.ReservationState? = null
        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
         */
        var resourceSpecification: aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification? = null
        /**
         * The day and time that the reservation becomes active. You set this value when you purchase the offering.
         */
        var start: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Reservation) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.durationUnits = x.durationUnits
            this.end = x.end
            this.offeringArn = x.offeringArn
            this.offeringDescription = x.offeringDescription
            this.pricePerUnit = x.pricePerUnit
            this.priceUnits = x.priceUnits
            this.reservationArn = x.reservationArn
            this.reservationName = x.reservationName
            this.reservationState = x.reservationState
            this.resourceSpecification = x.resourceSpecification
            this.start = x.start
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Reservation = Reservation(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification] inside the given [block]
         */
        fun resourceSpecification(block: aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification.Builder.() -> kotlin.Unit) {
            this.resourceSpecification = aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification.invoke(block)
        }
    }
}
