// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
 */
class Offering private constructor(builder: Builder) {
    /**
     * The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
     */
    val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The length of time that your reservation would be active.
     */
    val duration: kotlin.Int? = builder.duration
    /**
     * The unit of measurement for the duration of the offering.
     */
    val durationUnits: aws.sdk.kotlin.services.mediaconnect.model.DurationUnits? = builder.durationUnits
    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     */
    val offeringArn: kotlin.String? = builder.offeringArn
    /**
     * A description of the offering.
     */
    val offeringDescription: kotlin.String? = builder.offeringDescription
    /**
     * The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
     */
    val pricePerUnit: kotlin.String? = builder.pricePerUnit
    /**
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
     */
    val priceUnits: aws.sdk.kotlin.services.mediaconnect.model.PriceUnits? = builder.priceUnits
    /**
     * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
     */
    val resourceSpecification: aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification? = builder.resourceSpecification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Offering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Offering(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("durationUnits=$durationUnits,")
        append("offeringArn=$offeringArn,")
        append("offeringDescription=$offeringDescription,")
        append("pricePerUnit=$pricePerUnit,")
        append("priceUnits=$priceUnits,")
        append("resourceSpecification=$resourceSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (durationUnits?.hashCode() ?: 0)
        result = 31 * result + (offeringArn?.hashCode() ?: 0)
        result = 31 * result + (offeringDescription?.hashCode() ?: 0)
        result = 31 * result + (pricePerUnit?.hashCode() ?: 0)
        result = 31 * result + (priceUnits?.hashCode() ?: 0)
        result = 31 * result + (resourceSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Offering

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (durationUnits != other.durationUnits) return false
        if (offeringArn != other.offeringArn) return false
        if (offeringDescription != other.offeringDescription) return false
        if (pricePerUnit != other.pricePerUnit) return false
        if (priceUnits != other.priceUnits) return false
        if (resourceSpecification != other.resourceSpecification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Offering = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
         */
        var currencyCode: kotlin.String? = null
        /**
         * The length of time that your reservation would be active.
         */
        var duration: kotlin.Int? = null
        /**
         * The unit of measurement for the duration of the offering.
         */
        var durationUnits: aws.sdk.kotlin.services.mediaconnect.model.DurationUnits? = null
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         */
        var offeringArn: kotlin.String? = null
        /**
         * A description of the offering.
         */
        var offeringDescription: kotlin.String? = null
        /**
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
         */
        var pricePerUnit: kotlin.String? = null
        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
         */
        var priceUnits: aws.sdk.kotlin.services.mediaconnect.model.PriceUnits? = null
        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
         */
        var resourceSpecification: aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Offering) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.durationUnits = x.durationUnits
            this.offeringArn = x.offeringArn
            this.offeringDescription = x.offeringDescription
            this.pricePerUnit = x.pricePerUnit
            this.priceUnits = x.priceUnits
            this.resourceSpecification = x.resourceSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Offering = Offering(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification] inside the given [block]
         */
        fun resourceSpecification(block: aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification.Builder.() -> kotlin.Unit) {
            this.resourceSpecification = aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification.invoke(block)
        }
    }
}
