// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that you want to associate with the output, and the parameters for that association.
 */
class MediaStreamOutputConfigurationRequest private constructor(builder: Builder) {
    /**
     * The transport parameters that you want to associate with the media stream.
     */
    val destinationConfigurations: List<DestinationConfigurationRequest>? = builder.destinationConfigurations
    /**
     * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    val encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = builder.encodingName
    /**
     * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
     */
    val encodingParameters: aws.sdk.kotlin.services.mediaconnect.model.EncodingParametersRequest? = builder.encodingParameters
    /**
     * The name of the media stream that is associated with the output.
     */
    val mediaStreamName: kotlin.String? = builder.mediaStreamName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamOutputConfigurationRequest(")
        append("destinationConfigurations=$destinationConfigurations,")
        append("encodingName=$encodingName,")
        append("encodingParameters=$encodingParameters,")
        append("mediaStreamName=$mediaStreamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfigurations?.hashCode() ?: 0
        result = 31 * result + (encodingName?.hashCode() ?: 0)
        result = 31 * result + (encodingParameters?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MediaStreamOutputConfigurationRequest

        if (destinationConfigurations != other.destinationConfigurations) return false
        if (encodingName != other.encodingName) return false
        if (encodingParameters != other.encodingParameters) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfigurationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The transport parameters that you want to associate with the media stream.
         */
        var destinationConfigurations: List<DestinationConfigurationRequest>? = null
        /**
         * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        var encodingName: aws.sdk.kotlin.services.mediaconnect.model.EncodingName? = null
        /**
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
         */
        var encodingParameters: aws.sdk.kotlin.services.mediaconnect.model.EncodingParametersRequest? = null
        /**
         * The name of the media stream that is associated with the output.
         */
        var mediaStreamName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfigurationRequest) : this() {
            this.destinationConfigurations = x.destinationConfigurations
            this.encodingName = x.encodingName
            this.encodingParameters = x.encodingParameters
            this.mediaStreamName = x.mediaStreamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.MediaStreamOutputConfigurationRequest = MediaStreamOutputConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.EncodingParametersRequest] inside the given [block]
         */
        fun encodingParameters(block: aws.sdk.kotlin.services.mediaconnect.model.EncodingParametersRequest.Builder.() -> kotlin.Unit) {
            this.encodingParameters = aws.sdk.kotlin.services.mediaconnect.model.EncodingParametersRequest.invoke(block)
        }
    }
}
