// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for a flow, including its source, outputs, and entitlements.
 */
class Flow private constructor(builder: Builder) {
    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
     */
    val description: kotlin.String? = builder.description
    /**
     * The IP address from which video will be sent to output destinations.
     */
    val egressIp: kotlin.String? = builder.egressIp
    /**
     * The entitlements in this flow.
     */
    val entitlements: List<Entitlement>? = builder.entitlements
    /**
     * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
     */
    val flowArn: kotlin.String? = builder.flowArn
    /**
     * The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
     */
    val mediaStreams: List<MediaStream>? = builder.mediaStreams
    /**
     * The name of the flow.
     */
    val name: kotlin.String? = builder.name
    /**
     * The outputs in this flow.
     */
    val outputs: List<Output>? = builder.outputs
    /**
     * The settings for the source of the flow.
     */
    val source: aws.sdk.kotlin.services.mediaconnect.model.Source? = builder.source
    /**
     * The settings for source failover
     */
    val sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = builder.sourceFailoverConfig
    val sources: List<Source>? = builder.sources
    /**
     * The current status of the flow.
     */
    val status: aws.sdk.kotlin.services.mediaconnect.model.Status? = builder.status
    /**
     * The VPC Interfaces for this flow.
     */
    val vpcInterfaces: List<VpcInterface>? = builder.vpcInterfaces

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconnect.model.Flow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Flow(")
        append("availabilityZone=$availabilityZone,")
        append("description=$description,")
        append("egressIp=$egressIp,")
        append("entitlements=$entitlements,")
        append("flowArn=$flowArn,")
        append("mediaStreams=$mediaStreams,")
        append("name=$name,")
        append("outputs=$outputs,")
        append("source=$source,")
        append("sourceFailoverConfig=$sourceFailoverConfig,")
        append("sources=$sources,")
        append("status=$status,")
        append("vpcInterfaces=$vpcInterfaces)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (egressIp?.hashCode() ?: 0)
        result = 31 * result + (entitlements?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (mediaStreams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceFailoverConfig?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Flow

        if (availabilityZone != other.availabilityZone) return false
        if (description != other.description) return false
        if (egressIp != other.egressIp) return false
        if (entitlements != other.entitlements) return false
        if (flowArn != other.flowArn) return false
        if (mediaStreams != other.mediaStreams) return false
        if (name != other.name) return false
        if (outputs != other.outputs) return false
        if (source != other.source) return false
        if (sourceFailoverConfig != other.sourceFailoverConfig) return false
        if (sources != other.sources) return false
        if (status != other.status) return false
        if (vpcInterfaces != other.vpcInterfaces) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconnect.model.Flow = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        var description: kotlin.String? = null
        /**
         * The IP address from which video will be sent to output destinations.
         */
        var egressIp: kotlin.String? = null
        /**
         * The entitlements in this flow.
         */
        var entitlements: List<Entitlement>? = null
        /**
         * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
         */
        var flowArn: kotlin.String? = null
        /**
         * The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
         */
        var mediaStreams: List<MediaStream>? = null
        /**
         * The name of the flow.
         */
        var name: kotlin.String? = null
        /**
         * The outputs in this flow.
         */
        var outputs: List<Output>? = null
        /**
         * The settings for the source of the flow.
         */
        var source: aws.sdk.kotlin.services.mediaconnect.model.Source? = null
        /**
         * The settings for source failover
         */
        var sourceFailoverConfig: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig? = null
        var sources: List<Source>? = null
        /**
         * The current status of the flow.
         */
        var status: aws.sdk.kotlin.services.mediaconnect.model.Status? = null
        /**
         * The VPC Interfaces for this flow.
         */
        var vpcInterfaces: List<VpcInterface>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconnect.model.Flow) : this() {
            this.availabilityZone = x.availabilityZone
            this.description = x.description
            this.egressIp = x.egressIp
            this.entitlements = x.entitlements
            this.flowArn = x.flowArn
            this.mediaStreams = x.mediaStreams
            this.name = x.name
            this.outputs = x.outputs
            this.source = x.source
            this.sourceFailoverConfig = x.sourceFailoverConfig
            this.sources = x.sources
            this.status = x.status
            this.vpcInterfaces = x.vpcInterfaces
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconnect.model.Flow = Flow(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Source] inside the given [block]
         */
        fun source(block: aws.sdk.kotlin.services.mediaconnect.model.Source.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.mediaconnect.model.Source.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig] inside the given [block]
         */
        fun sourceFailoverConfig(block: aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.Builder.() -> kotlin.Unit) {
            this.sourceFailoverConfig = aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig.invoke(block)
        }
    }
}
