// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.mediaconnect.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediaconnect.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * API for AWS Elemental MediaConnect
 */
interface MediaConnectClient : SdkClient {

    override val serviceName: String
        get() = "MediaConnect"
    /**
     * MediaConnectClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): MediaConnectClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultMediaConnectClient(config)
        }

        operator fun invoke(config: Config): MediaConnectClient = DefaultMediaConnectClient(config)

        /**
         * Construct a [MediaConnectClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): MediaConnectClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return MediaConnectClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     */
    suspend fun addFlowMediaStreams(input: AddFlowMediaStreamsRequest): AddFlowMediaStreamsResponse

    /**
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     */
    suspend fun addFlowMediaStreams(block: AddFlowMediaStreamsRequest.Builder.() -> Unit) = addFlowMediaStreams(AddFlowMediaStreamsRequest.Builder().apply(block).build())

    /**
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     */
    suspend fun addFlowOutputs(input: AddFlowOutputsRequest): AddFlowOutputsResponse

    /**
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     */
    suspend fun addFlowOutputs(block: AddFlowOutputsRequest.Builder.() -> Unit) = addFlowOutputs(AddFlowOutputsRequest.Builder().apply(block).build())

    /**
     * Adds Sources to flow
     */
    suspend fun addFlowSources(input: AddFlowSourcesRequest): AddFlowSourcesResponse

    /**
     * Adds Sources to flow
     */
    suspend fun addFlowSources(block: AddFlowSourcesRequest.Builder.() -> Unit) = addFlowSources(AddFlowSourcesRequest.Builder().apply(block).build())

    /**
     * Adds VPC interfaces to flow
     */
    suspend fun addFlowVpcInterfaces(input: AddFlowVpcInterfacesRequest): AddFlowVpcInterfacesResponse

    /**
     * Adds VPC interfaces to flow
     */
    suspend fun addFlowVpcInterfaces(block: AddFlowVpcInterfacesRequest.Builder.() -> Unit) = addFlowVpcInterfaces(AddFlowVpcInterfacesRequest.Builder().apply(block).build())

    /**
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
     */
    suspend fun createFlow(input: CreateFlowRequest): CreateFlowResponse

    /**
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
     */
    suspend fun createFlow(block: CreateFlowRequest.Builder.() -> Unit) = createFlow(CreateFlowRequest.Builder().apply(block).build())

    /**
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     */
    suspend fun deleteFlow(input: DeleteFlowRequest): DeleteFlowResponse

    /**
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     */
    suspend fun deleteFlow(block: DeleteFlowRequest.Builder.() -> Unit) = deleteFlow(DeleteFlowRequest.Builder().apply(block).build())

    /**
     * Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     */
    suspend fun describeFlow(input: DescribeFlowRequest): DescribeFlowResponse

    /**
     * Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     */
    suspend fun describeFlow(block: DescribeFlowRequest.Builder.() -> Unit) = describeFlow(DescribeFlowRequest.Builder().apply(block).build())

    /**
     * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
     */
    suspend fun describeOffering(input: DescribeOfferingRequest): DescribeOfferingResponse

    /**
     * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
     */
    suspend fun describeOffering(block: DescribeOfferingRequest.Builder.() -> Unit) = describeOffering(DescribeOfferingRequest.Builder().apply(block).build())

    /**
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
     */
    suspend fun describeReservation(input: DescribeReservationRequest): DescribeReservationResponse

    /**
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
     */
    suspend fun describeReservation(block: DescribeReservationRequest.Builder.() -> Unit) = describeReservation(DescribeReservationRequest.Builder().apply(block).build())

    /**
     * Grants entitlements to an existing flow.
     */
    suspend fun grantFlowEntitlements(input: GrantFlowEntitlementsRequest): GrantFlowEntitlementsResponse

    /**
     * Grants entitlements to an existing flow.
     */
    suspend fun grantFlowEntitlements(block: GrantFlowEntitlementsRequest.Builder.() -> Unit) = grantFlowEntitlements(GrantFlowEntitlementsRequest.Builder().apply(block).build())

    /**
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
     */
    suspend fun listEntitlements(input: ListEntitlementsRequest): ListEntitlementsResponse

    /**
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
     */
    suspend fun listEntitlements(block: ListEntitlementsRequest.Builder.() -> Unit) = listEntitlements(ListEntitlementsRequest.Builder().apply(block).build())

    /**
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     */
    suspend fun listFlows(input: ListFlowsRequest): ListFlowsResponse

    /**
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     */
    suspend fun listFlows(block: ListFlowsRequest.Builder.() -> Unit) = listFlows(ListFlowsRequest.Builder().apply(block).build())

    /**
     * Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
     */
    suspend fun listOfferings(input: ListOfferingsRequest): ListOfferingsResponse

    /**
     * Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
     */
    suspend fun listOfferings(block: ListOfferingsRequest.Builder.() -> Unit) = listOfferings(ListOfferingsRequest.Builder().apply(block).build())

    /**
     * Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
     */
    suspend fun listReservations(input: ListReservationsRequest): ListReservationsResponse

    /**
     * Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
     */
    suspend fun listReservations(block: ListReservationsRequest.Builder.() -> Unit) = listReservations(ListReservationsRequest.Builder().apply(block).build())

    /**
     * List all tags on an AWS Elemental MediaConnect resource
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List all tags on an AWS Elemental MediaConnect resource
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
     */
    suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse

    /**
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
     */
    suspend fun purchaseOffering(block: PurchaseOfferingRequest.Builder.() -> Unit) = purchaseOffering(PurchaseOfferingRequest.Builder().apply(block).build())

    /**
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
     */
    suspend fun removeFlowMediaStream(input: RemoveFlowMediaStreamRequest): RemoveFlowMediaStreamResponse

    /**
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
     */
    suspend fun removeFlowMediaStream(block: RemoveFlowMediaStreamRequest.Builder.() -> Unit) = removeFlowMediaStream(RemoveFlowMediaStreamRequest.Builder().apply(block).build())

    /**
     * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
     */
    suspend fun removeFlowOutput(input: RemoveFlowOutputRequest): RemoveFlowOutputResponse

    /**
     * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
     */
    suspend fun removeFlowOutput(block: RemoveFlowOutputRequest.Builder.() -> Unit) = removeFlowOutput(RemoveFlowOutputRequest.Builder().apply(block).build())

    /**
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
     */
    suspend fun removeFlowSource(input: RemoveFlowSourceRequest): RemoveFlowSourceResponse

    /**
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
     */
    suspend fun removeFlowSource(block: RemoveFlowSourceRequest.Builder.() -> Unit) = removeFlowSource(RemoveFlowSourceRequest.Builder().apply(block).build())

    /**
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
     */
    suspend fun removeFlowVpcInterface(input: RemoveFlowVpcInterfaceRequest): RemoveFlowVpcInterfaceResponse

    /**
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
     */
    suspend fun removeFlowVpcInterface(block: RemoveFlowVpcInterfaceRequest.Builder.() -> Unit) = removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest.Builder().apply(block).build())

    /**
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
     */
    suspend fun revokeFlowEntitlement(input: RevokeFlowEntitlementRequest): RevokeFlowEntitlementResponse

    /**
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
     */
    suspend fun revokeFlowEntitlement(block: RevokeFlowEntitlementRequest.Builder.() -> Unit) = revokeFlowEntitlement(RevokeFlowEntitlementRequest.Builder().apply(block).build())

    /**
     * Starts a flow.
     */
    suspend fun startFlow(input: StartFlowRequest): StartFlowResponse

    /**
     * Starts a flow.
     */
    suspend fun startFlow(block: StartFlowRequest.Builder.() -> Unit) = startFlow(StartFlowRequest.Builder().apply(block).build())

    /**
     * Stops a flow.
     */
    suspend fun stopFlow(input: StopFlowRequest): StopFlowResponse

    /**
     * Stops a flow.
     */
    suspend fun stopFlow(block: StopFlowRequest.Builder.() -> Unit) = stopFlow(StopFlowRequest.Builder().apply(block).build())

    /**
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates flow
     */
    suspend fun updateFlow(input: UpdateFlowRequest): UpdateFlowResponse

    /**
     * Updates flow
     */
    suspend fun updateFlow(block: UpdateFlowRequest.Builder.() -> Unit) = updateFlow(UpdateFlowRequest.Builder().apply(block).build())

    /**
     * You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     */
    suspend fun updateFlowEntitlement(input: UpdateFlowEntitlementRequest): UpdateFlowEntitlementResponse

    /**
     * You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     */
    suspend fun updateFlowEntitlement(block: UpdateFlowEntitlementRequest.Builder.() -> Unit) = updateFlowEntitlement(UpdateFlowEntitlementRequest.Builder().apply(block).build())

    /**
     * Updates an existing media stream.
     */
    suspend fun updateFlowMediaStream(input: UpdateFlowMediaStreamRequest): UpdateFlowMediaStreamResponse

    /**
     * Updates an existing media stream.
     */
    suspend fun updateFlowMediaStream(block: UpdateFlowMediaStreamRequest.Builder.() -> Unit) = updateFlowMediaStream(UpdateFlowMediaStreamRequest.Builder().apply(block).build())

    /**
     * Updates an existing flow output.
     */
    suspend fun updateFlowOutput(input: UpdateFlowOutputRequest): UpdateFlowOutputResponse

    /**
     * Updates an existing flow output.
     */
    suspend fun updateFlowOutput(block: UpdateFlowOutputRequest.Builder.() -> Unit) = updateFlowOutput(UpdateFlowOutputRequest.Builder().apply(block).build())

    /**
     * Updates the source of a flow.
     */
    suspend fun updateFlowSource(input: UpdateFlowSourceRequest): UpdateFlowSourceResponse

    /**
     * Updates the source of a flow.
     */
    suspend fun updateFlowSource(block: UpdateFlowSourceRequest.Builder.() -> Unit) = updateFlowSource(UpdateFlowSourceRequest.Builder().apply(block).build())
}
