// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.transform

import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowSourceRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFlowSourceOperationSerializer: HttpSerialize<UpdateFlowSourceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFlowSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "v1",
                "flows",
                "${input.flowArn}".encodeLabel(),
                "source",
                "${input.sourceArn}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateFlowSourceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFlowSourceOperationBody(context: ExecutionContext, input: UpdateFlowSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val DECRYPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("decryption"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENTITLEMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entitlementArn"))
    val INGESTPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ingestPort"))
    val MAXBITRATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxBitrate"))
    val MAXLATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxLatency"))
    val MAXSYNCBUFFER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxSyncBuffer"))
    val MEDIASTREAMSOURCECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mediaStreamSourceConfigurations"))
    val MINLATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("minLatency"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("protocol"))
    val STREAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("streamId"))
    val VPCINTERFACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcInterfaceName"))
    val WHITELISTCIDR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("whitelistCidr"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DECRYPTION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENTITLEMENTARN_DESCRIPTOR)
        field(INGESTPORT_DESCRIPTOR)
        field(MAXBITRATE_DESCRIPTOR)
        field(MAXLATENCY_DESCRIPTOR)
        field(MAXSYNCBUFFER_DESCRIPTOR)
        field(MEDIASTREAMSOURCECONFIGURATIONS_DESCRIPTOR)
        field(MINLATENCY_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(STREAMID_DESCRIPTOR)
        field(VPCINTERFACENAME_DESCRIPTOR)
        field(WHITELISTCIDR_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.decryption?.let { field(DECRYPTION_DESCRIPTOR, it, ::serializeUpdateEncryptionDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.entitlementArn?.let { field(ENTITLEMENTARN_DESCRIPTOR, it) }
        input.ingestPort?.let { field(INGESTPORT_DESCRIPTOR, it) }
        input.maxBitrate?.let { field(MAXBITRATE_DESCRIPTOR, it) }
        input.maxLatency?.let { field(MAXLATENCY_DESCRIPTOR, it) }
        input.maxSyncBuffer?.let { field(MAXSYNCBUFFER_DESCRIPTOR, it) }
        if (input.mediaStreamSourceConfigurations != null) {
            listField(MEDIASTREAMSOURCECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.mediaStreamSourceConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMediaStreamSourceConfigurationRequestDocument))
                }
            }
        }
        input.minLatency?.let { field(MINLATENCY_DESCRIPTOR, it) }
        input.protocol?.let { field(PROTOCOL_DESCRIPTOR, it.value) }
        input.streamId?.let { field(STREAMID_DESCRIPTOR, it) }
        input.vpcInterfaceName?.let { field(VPCINTERFACENAME_DESCRIPTOR, it) }
        input.whitelistCidr?.let { field(WHITELISTCIDR_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
