// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for source failover
 */
class UpdateFailoverConfig private constructor(builder: BuilderImpl) {
    /**
     * The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
     */
    val failoverMode: FailoverMode? = builder.failoverMode
    /**
     * Recovery window time to look for dash-7 packets
     */
    val recoveryWindow: Int? = builder.recoveryWindow
    /**
     * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
     */
    val sourcePriority: SourcePriority? = builder.sourcePriority
    val state: State? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFailoverConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFailoverConfig(")
        append("failoverMode=$failoverMode,")
        append("recoveryWindow=$recoveryWindow,")
        append("sourcePriority=$sourcePriority,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failoverMode?.hashCode() ?: 0
        result = 31 * result + (recoveryWindow ?: 0)
        result = 31 * result + (sourcePriority?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFailoverConfig

        if (failoverMode != other.failoverMode) return false
        if (recoveryWindow != other.recoveryWindow) return false
        if (sourcePriority != other.sourcePriority) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFailoverConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFailoverConfig
        /**
         * The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
         */
        fun failoverMode(failoverMode: FailoverMode): FluentBuilder
        /**
         * Recovery window time to look for dash-7 packets
         */
        fun recoveryWindow(recoveryWindow: Int): FluentBuilder
        /**
         * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
         */
        fun sourcePriority(sourcePriority: SourcePriority): FluentBuilder
        fun state(state: State): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
         */
        var failoverMode: FailoverMode?
        /**
         * Recovery window time to look for dash-7 packets
         */
        var recoveryWindow: Int?
        /**
         * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
         */
        var sourcePriority: SourcePriority?
        var state: State?

        fun build(): UpdateFailoverConfig
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.SourcePriority] inside the given [block]
         */
        fun sourcePriority(block: SourcePriority.DslBuilder.() -> kotlin.Unit) {
            this.sourcePriority = SourcePriority.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var failoverMode: FailoverMode? = null
        override var recoveryWindow: Int? = null
        override var sourcePriority: SourcePriority? = null
        override var state: State? = null

        constructor(x: UpdateFailoverConfig) : this() {
            this.failoverMode = x.failoverMode
            this.recoveryWindow = x.recoveryWindow
            this.sourcePriority = x.sourcePriority
            this.state = x.state
        }

        override fun build(): UpdateFailoverConfig = UpdateFailoverConfig(this)
        override fun failoverMode(failoverMode: FailoverMode): FluentBuilder = apply { this.failoverMode = failoverMode }
        override fun recoveryWindow(recoveryWindow: Int): FluentBuilder = apply { this.recoveryWindow = recoveryWindow }
        override fun sourcePriority(sourcePriority: SourcePriority): FluentBuilder = apply { this.sourcePriority = sourcePriority }
        override fun state(state: State): FluentBuilder = apply { this.state = state }
    }
}
