// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Attributes related to the transport stream that are used in a source or output.
 */
class Transport private constructor(builder: BuilderImpl) {
    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val cidrAllowList: List<String>? = builder.cidrAllowList
    /**
     * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     */
    val maxBitrate: Int? = builder.maxBitrate
    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
     */
    val maxLatency: Int? = builder.maxLatency
    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    val maxSyncBuffer: Int? = builder.maxSyncBuffer
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    val minLatency: Int? = builder.minLatency
    /**
     * The protocol that is used by the source or output.
     */
    val protocol: Protocol? = builder.protocol
    /**
     * The remote ID for the Zixi-pull stream.
     */
    val remoteId: String? = builder.remoteId
    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    val smoothingLatency: Int? = builder.smoothingLatency
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    val streamId: String? = builder.streamId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Transport = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Transport(")
        append("cidrAllowList=$cidrAllowList,")
        append("maxBitrate=$maxBitrate,")
        append("maxLatency=$maxLatency,")
        append("maxSyncBuffer=$maxSyncBuffer,")
        append("minLatency=$minLatency,")
        append("protocol=$protocol,")
        append("remoteId=$remoteId,")
        append("smoothingLatency=$smoothingLatency,")
        append("streamId=$streamId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrAllowList?.hashCode() ?: 0
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (maxSyncBuffer ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (remoteId?.hashCode() ?: 0)
        result = 31 * result + (smoothingLatency ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Transport

        if (cidrAllowList != other.cidrAllowList) return false
        if (maxBitrate != other.maxBitrate) return false
        if (maxLatency != other.maxLatency) return false
        if (maxSyncBuffer != other.maxSyncBuffer) return false
        if (minLatency != other.minLatency) return false
        if (protocol != other.protocol) return false
        if (remoteId != other.remoteId) return false
        if (smoothingLatency != other.smoothingLatency) return false
        if (streamId != other.streamId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Transport = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Transport
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        fun cidrAllowList(cidrAllowList: List<String>): FluentBuilder
        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         */
        fun maxBitrate(maxBitrate: Int): FluentBuilder
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         */
        fun maxLatency(maxLatency: Int): FluentBuilder
        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         */
        fun maxSyncBuffer(maxSyncBuffer: Int): FluentBuilder
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        fun minLatency(minLatency: Int): FluentBuilder
        /**
         * The protocol that is used by the source or output.
         */
        fun protocol(protocol: Protocol): FluentBuilder
        /**
         * The remote ID for the Zixi-pull stream.
         */
        fun remoteId(remoteId: String): FluentBuilder
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        fun smoothingLatency(smoothingLatency: Int): FluentBuilder
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        fun streamId(streamId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var cidrAllowList: List<String>?
        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         */
        var maxBitrate: Int?
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         */
        var maxLatency: Int?
        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         */
        var maxSyncBuffer: Int?
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        var minLatency: Int?
        /**
         * The protocol that is used by the source or output.
         */
        var protocol: Protocol?
        /**
         * The remote ID for the Zixi-pull stream.
         */
        var remoteId: String?
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        var smoothingLatency: Int?
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        var streamId: String?

        fun build(): Transport
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrAllowList: List<String>? = null
        override var maxBitrate: Int? = null
        override var maxLatency: Int? = null
        override var maxSyncBuffer: Int? = null
        override var minLatency: Int? = null
        override var protocol: Protocol? = null
        override var remoteId: String? = null
        override var smoothingLatency: Int? = null
        override var streamId: String? = null

        constructor(x: Transport) : this() {
            this.cidrAllowList = x.cidrAllowList
            this.maxBitrate = x.maxBitrate
            this.maxLatency = x.maxLatency
            this.maxSyncBuffer = x.maxSyncBuffer
            this.minLatency = x.minLatency
            this.protocol = x.protocol
            this.remoteId = x.remoteId
            this.smoothingLatency = x.smoothingLatency
            this.streamId = x.streamId
        }

        override fun build(): Transport = Transport(this)
        override fun cidrAllowList(cidrAllowList: List<String>): FluentBuilder = apply { this.cidrAllowList = cidrAllowList }
        override fun maxBitrate(maxBitrate: Int): FluentBuilder = apply { this.maxBitrate = maxBitrate }
        override fun maxLatency(maxLatency: Int): FluentBuilder = apply { this.maxLatency = maxLatency }
        override fun maxSyncBuffer(maxSyncBuffer: Int): FluentBuilder = apply { this.maxSyncBuffer = maxSyncBuffer }
        override fun minLatency(minLatency: Int): FluentBuilder = apply { this.minLatency = minLatency }
        override fun protocol(protocol: Protocol): FluentBuilder = apply { this.protocol = protocol }
        override fun remoteId(remoteId: String): FluentBuilder = apply { this.remoteId = remoteId }
        override fun smoothingLatency(smoothingLatency: Int): FluentBuilder = apply { this.smoothingLatency = smoothingLatency }
        override fun streamId(streamId: String): FluentBuilder = apply { this.streamId = streamId }
    }
}
