// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
 */
class TagResourceRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
     */
    val resourceArn: String? = builder.resourceArn
    /**
     * A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TagResourceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TagResourceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TagResourceRequest
        /**
         * The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
         */
        fun resourceArn(resourceArn: String): FluentBuilder
        /**
         * A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
         */
        var resourceArn: String?
        /**
         * A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         */
        var tags: Map<String, String>?

        fun build(): TagResourceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var resourceArn: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        override fun build(): TagResourceRequest = TagResourceRequest(this)
        override fun resourceArn(resourceArn: String): FluentBuilder = apply { this.resourceArn = resourceArn }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
