// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for the source of the flow.
 */
class Source private constructor(builder: BuilderImpl) {
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    val dataTransferSubscriberFeePercent: Int? = builder.dataTransferSubscriberFeePercent
    /**
     * The type of encryption that is used on the content ingested from this source.
     */
    val decryption: Encryption? = builder.decryption
    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
     */
    val description: String? = builder.description
    /**
     * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
     */
    val entitlementArn: String? = builder.entitlementArn
    /**
     * The IP address that the flow will be listening on for incoming content.
     */
    val ingestIp: String? = builder.ingestIp
    /**
     * The port that the flow will be listening on for incoming content.
     */
    val ingestPort: Int? = builder.ingestPort
    /**
     * The media streams that are associated with the source, and the parameters for those associations.
     */
    val mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>? = builder.mediaStreamSourceConfigurations
    /**
     * The name of the source.
     */
    val name: String? = builder.name
    /**
     * The ARN of the source.
     */
    val sourceArn: String? = builder.sourceArn
    /**
     * Attributes related to the transport stream that are used in the source.
     */
    val transport: Transport? = builder.transport
    /**
     * The name of the VPC interface that is used for this source.
     */
    val vpcInterfaceName: String? = builder.vpcInterfaceName
    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val whitelistCidr: String? = builder.whitelistCidr

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Source = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Source(")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("decryption=$decryption,")
        append("description=$description,")
        append("entitlementArn=$entitlementArn,")
        append("ingestIp=$ingestIp,")
        append("ingestPort=$ingestPort,")
        append("mediaStreamSourceConfigurations=$mediaStreamSourceConfigurations,")
        append("name=$name,")
        append("sourceArn=$sourceArn,")
        append("transport=$transport,")
        append("vpcInterfaceName=$vpcInterfaceName,")
        append("whitelistCidr=$whitelistCidr)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferSubscriberFeePercent ?: 0
        result = 31 * result + (decryption?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (ingestIp?.hashCode() ?: 0)
        result = 31 * result + (ingestPort ?: 0)
        result = 31 * result + (mediaStreamSourceConfigurations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (transport?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (whitelistCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Source

        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (decryption != other.decryption) return false
        if (description != other.description) return false
        if (entitlementArn != other.entitlementArn) return false
        if (ingestIp != other.ingestIp) return false
        if (ingestPort != other.ingestPort) return false
        if (mediaStreamSourceConfigurations != other.mediaStreamSourceConfigurations) return false
        if (name != other.name) return false
        if (sourceArn != other.sourceArn) return false
        if (transport != other.transport) return false
        if (vpcInterfaceName != other.vpcInterfaceName) return false
        if (whitelistCidr != other.whitelistCidr) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Source = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Source
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        fun dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent: Int): FluentBuilder
        /**
         * The type of encryption that is used on the content ingested from this source.
         */
        fun decryption(decryption: Encryption): FluentBuilder
        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
         */
        fun entitlementArn(entitlementArn: String): FluentBuilder
        /**
         * The IP address that the flow will be listening on for incoming content.
         */
        fun ingestIp(ingestIp: String): FluentBuilder
        /**
         * The port that the flow will be listening on for incoming content.
         */
        fun ingestPort(ingestPort: Int): FluentBuilder
        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         */
        fun mediaStreamSourceConfigurations(mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>): FluentBuilder
        /**
         * The name of the source.
         */
        fun name(name: String): FluentBuilder
        /**
         * The ARN of the source.
         */
        fun sourceArn(sourceArn: String): FluentBuilder
        /**
         * Attributes related to the transport stream that are used in the source.
         */
        fun transport(transport: Transport): FluentBuilder
        /**
         * The name of the VPC interface that is used for this source.
         */
        fun vpcInterfaceName(vpcInterfaceName: String): FluentBuilder
        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        fun whitelistCidr(whitelistCidr: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        var dataTransferSubscriberFeePercent: Int?
        /**
         * The type of encryption that is used on the content ingested from this source.
         */
        var decryption: Encryption?
        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        var description: String?
        /**
         * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
         */
        var entitlementArn: String?
        /**
         * The IP address that the flow will be listening on for incoming content.
         */
        var ingestIp: String?
        /**
         * The port that the flow will be listening on for incoming content.
         */
        var ingestPort: Int?
        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         */
        var mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>?
        /**
         * The name of the source.
         */
        var name: String?
        /**
         * The ARN of the source.
         */
        var sourceArn: String?
        /**
         * Attributes related to the transport stream that are used in the source.
         */
        var transport: Transport?
        /**
         * The name of the VPC interface that is used for this source.
         */
        var vpcInterfaceName: String?
        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var whitelistCidr: String?

        fun build(): Source
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        fun decryption(block: Encryption.DslBuilder.() -> kotlin.Unit) {
            this.decryption = Encryption.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Transport] inside the given [block]
         */
        fun transport(block: Transport.DslBuilder.() -> kotlin.Unit) {
            this.transport = Transport.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataTransferSubscriberFeePercent: Int? = null
        override var decryption: Encryption? = null
        override var description: String? = null
        override var entitlementArn: String? = null
        override var ingestIp: String? = null
        override var ingestPort: Int? = null
        override var mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>? = null
        override var name: String? = null
        override var sourceArn: String? = null
        override var transport: Transport? = null
        override var vpcInterfaceName: String? = null
        override var whitelistCidr: String? = null

        constructor(x: Source) : this() {
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.decryption = x.decryption
            this.description = x.description
            this.entitlementArn = x.entitlementArn
            this.ingestIp = x.ingestIp
            this.ingestPort = x.ingestPort
            this.mediaStreamSourceConfigurations = x.mediaStreamSourceConfigurations
            this.name = x.name
            this.sourceArn = x.sourceArn
            this.transport = x.transport
            this.vpcInterfaceName = x.vpcInterfaceName
            this.whitelistCidr = x.whitelistCidr
        }

        override fun build(): Source = Source(this)
        override fun dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent: Int): FluentBuilder = apply { this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent }
        override fun decryption(decryption: Encryption): FluentBuilder = apply { this.decryption = decryption }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun entitlementArn(entitlementArn: String): FluentBuilder = apply { this.entitlementArn = entitlementArn }
        override fun ingestIp(ingestIp: String): FluentBuilder = apply { this.ingestIp = ingestIp }
        override fun ingestPort(ingestPort: Int): FluentBuilder = apply { this.ingestPort = ingestPort }
        override fun mediaStreamSourceConfigurations(mediaStreamSourceConfigurations: List<MediaStreamSourceConfiguration>): FluentBuilder = apply { this.mediaStreamSourceConfigurations = mediaStreamSourceConfigurations }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun sourceArn(sourceArn: String): FluentBuilder = apply { this.sourceArn = sourceArn }
        override fun transport(transport: Transport): FluentBuilder = apply { this.transport = transport }
        override fun vpcInterfaceName(vpcInterfaceName: String): FluentBuilder = apply { this.vpcInterfaceName = vpcInterfaceName }
        override fun whitelistCidr(whitelistCidr: String): FluentBuilder = apply { this.whitelistCidr = whitelistCidr }
    }
}
