// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for the source of the flow.
 */
class SetSourceRequest private constructor(builder: BuilderImpl) {
    /**
     * The type of encryption that is used on the content ingested from this source.
     */
    val decryption: Encryption? = builder.decryption
    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
     */
    val description: String? = builder.description
    /**
     * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
     */
    val entitlementArn: String? = builder.entitlementArn
    /**
     * The port that the flow will be listening on for incoming content.
     */
    val ingestPort: Int? = builder.ingestPort
    /**
     * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     */
    val maxBitrate: Int? = builder.maxBitrate
    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
     */
    val maxLatency: Int? = builder.maxLatency
    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    val maxSyncBuffer: Int? = builder.maxSyncBuffer
    /**
     * The media streams that are associated with the source, and the parameters for those associations.
     */
    val mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>? = builder.mediaStreamSourceConfigurations
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    val minLatency: Int? = builder.minLatency
    /**
     * The name of the source.
     */
    val name: String? = builder.name
    /**
     * The protocol that is used by the source.
     */
    val protocol: Protocol? = builder.protocol
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    val streamId: String? = builder.streamId
    /**
     * The name of the VPC interface to use for this source.
     */
    val vpcInterfaceName: String? = builder.vpcInterfaceName
    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val whitelistCidr: String? = builder.whitelistCidr

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SetSourceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SetSourceRequest(")
        append("decryption=$decryption,")
        append("description=$description,")
        append("entitlementArn=$entitlementArn,")
        append("ingestPort=$ingestPort,")
        append("maxBitrate=$maxBitrate,")
        append("maxLatency=$maxLatency,")
        append("maxSyncBuffer=$maxSyncBuffer,")
        append("mediaStreamSourceConfigurations=$mediaStreamSourceConfigurations,")
        append("minLatency=$minLatency,")
        append("name=$name,")
        append("protocol=$protocol,")
        append("streamId=$streamId,")
        append("vpcInterfaceName=$vpcInterfaceName,")
        append("whitelistCidr=$whitelistCidr)")
    }

    override fun hashCode(): kotlin.Int {
        var result = decryption?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (ingestPort ?: 0)
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (maxSyncBuffer ?: 0)
        result = 31 * result + (mediaStreamSourceConfigurations?.hashCode() ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceName?.hashCode() ?: 0)
        result = 31 * result + (whitelistCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SetSourceRequest

        if (decryption != other.decryption) return false
        if (description != other.description) return false
        if (entitlementArn != other.entitlementArn) return false
        if (ingestPort != other.ingestPort) return false
        if (maxBitrate != other.maxBitrate) return false
        if (maxLatency != other.maxLatency) return false
        if (maxSyncBuffer != other.maxSyncBuffer) return false
        if (mediaStreamSourceConfigurations != other.mediaStreamSourceConfigurations) return false
        if (minLatency != other.minLatency) return false
        if (name != other.name) return false
        if (protocol != other.protocol) return false
        if (streamId != other.streamId) return false
        if (vpcInterfaceName != other.vpcInterfaceName) return false
        if (whitelistCidr != other.whitelistCidr) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SetSourceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SetSourceRequest
        /**
         * The type of encryption that is used on the content ingested from this source.
         */
        fun decryption(decryption: Encryption): FluentBuilder
        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
         */
        fun entitlementArn(entitlementArn: String): FluentBuilder
        /**
         * The port that the flow will be listening on for incoming content.
         */
        fun ingestPort(ingestPort: Int): FluentBuilder
        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         */
        fun maxBitrate(maxBitrate: Int): FluentBuilder
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         */
        fun maxLatency(maxLatency: Int): FluentBuilder
        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         */
        fun maxSyncBuffer(maxSyncBuffer: Int): FluentBuilder
        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         */
        fun mediaStreamSourceConfigurations(mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>): FluentBuilder
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        fun minLatency(minLatency: Int): FluentBuilder
        /**
         * The name of the source.
         */
        fun name(name: String): FluentBuilder
        /**
         * The protocol that is used by the source.
         */
        fun protocol(protocol: Protocol): FluentBuilder
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        fun streamId(streamId: String): FluentBuilder
        /**
         * The name of the VPC interface to use for this source.
         */
        fun vpcInterfaceName(vpcInterfaceName: String): FluentBuilder
        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        fun whitelistCidr(whitelistCidr: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of encryption that is used on the content ingested from this source.
         */
        var decryption: Encryption?
        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        var description: String?
        /**
         * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
         */
        var entitlementArn: String?
        /**
         * The port that the flow will be listening on for incoming content.
         */
        var ingestPort: Int?
        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         */
        var maxBitrate: Int?
        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
         */
        var maxLatency: Int?
        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         */
        var maxSyncBuffer: Int?
        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         */
        var mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>?
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        var minLatency: Int?
        /**
         * The name of the source.
         */
        var name: String?
        /**
         * The protocol that is used by the source.
         */
        var protocol: Protocol?
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        var streamId: String?
        /**
         * The name of the VPC interface to use for this source.
         */
        var vpcInterfaceName: String?
        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var whitelistCidr: String?

        fun build(): SetSourceRequest
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        fun decryption(block: Encryption.DslBuilder.() -> kotlin.Unit) {
            this.decryption = Encryption.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var decryption: Encryption? = null
        override var description: String? = null
        override var entitlementArn: String? = null
        override var ingestPort: Int? = null
        override var maxBitrate: Int? = null
        override var maxLatency: Int? = null
        override var maxSyncBuffer: Int? = null
        override var mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>? = null
        override var minLatency: Int? = null
        override var name: String? = null
        override var protocol: Protocol? = null
        override var streamId: String? = null
        override var vpcInterfaceName: String? = null
        override var whitelistCidr: String? = null

        constructor(x: SetSourceRequest) : this() {
            this.decryption = x.decryption
            this.description = x.description
            this.entitlementArn = x.entitlementArn
            this.ingestPort = x.ingestPort
            this.maxBitrate = x.maxBitrate
            this.maxLatency = x.maxLatency
            this.maxSyncBuffer = x.maxSyncBuffer
            this.mediaStreamSourceConfigurations = x.mediaStreamSourceConfigurations
            this.minLatency = x.minLatency
            this.name = x.name
            this.protocol = x.protocol
            this.streamId = x.streamId
            this.vpcInterfaceName = x.vpcInterfaceName
            this.whitelistCidr = x.whitelistCidr
        }

        override fun build(): SetSourceRequest = SetSourceRequest(this)
        override fun decryption(decryption: Encryption): FluentBuilder = apply { this.decryption = decryption }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun entitlementArn(entitlementArn: String): FluentBuilder = apply { this.entitlementArn = entitlementArn }
        override fun ingestPort(ingestPort: Int): FluentBuilder = apply { this.ingestPort = ingestPort }
        override fun maxBitrate(maxBitrate: Int): FluentBuilder = apply { this.maxBitrate = maxBitrate }
        override fun maxLatency(maxLatency: Int): FluentBuilder = apply { this.maxLatency = maxLatency }
        override fun maxSyncBuffer(maxSyncBuffer: Int): FluentBuilder = apply { this.maxSyncBuffer = maxSyncBuffer }
        override fun mediaStreamSourceConfigurations(mediaStreamSourceConfigurations: List<MediaStreamSourceConfigurationRequest>): FluentBuilder = apply { this.mediaStreamSourceConfigurations = mediaStreamSourceConfigurations }
        override fun minLatency(minLatency: Int): FluentBuilder = apply { this.minLatency = minLatency }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun protocol(protocol: Protocol): FluentBuilder = apply { this.protocol = protocol }
        override fun streamId(streamId: String): FluentBuilder = apply { this.streamId = streamId }
        override fun vpcInterfaceName(vpcInterfaceName: String): FluentBuilder = apply { this.vpcInterfaceName = vpcInterfaceName }
        override fun whitelistCidr(whitelistCidr: String): FluentBuilder = apply { this.whitelistCidr = whitelistCidr }
    }
}
