// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A request to purchase a offering.
 */
class PurchaseOfferingRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the offering.
     */
    val offeringArn: String? = builder.offeringArn
    /**
     * The name that you want to use for the reservation.
     */
    val reservationName: String? = builder.reservationName
    /**
     * The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
     */
    val start: String? = builder.start

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PurchaseOfferingRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PurchaseOfferingRequest(")
        append("offeringArn=$offeringArn,")
        append("reservationName=$reservationName,")
        append("start=$start)")
    }

    override fun hashCode(): kotlin.Int {
        var result = offeringArn?.hashCode() ?: 0
        result = 31 * result + (reservationName?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PurchaseOfferingRequest

        if (offeringArn != other.offeringArn) return false
        if (reservationName != other.reservationName) return false
        if (start != other.start) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PurchaseOfferingRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PurchaseOfferingRequest
        /**
         * The Amazon Resource Name (ARN) of the offering.
         */
        fun offeringArn(offeringArn: String): FluentBuilder
        /**
         * The name that you want to use for the reservation.
         */
        fun reservationName(reservationName: String): FluentBuilder
        /**
         * The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
         */
        fun start(start: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the offering.
         */
        var offeringArn: String?
        /**
         * The name that you want to use for the reservation.
         */
        var reservationName: String?
        /**
         * The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
         */
        var start: String?

        fun build(): PurchaseOfferingRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var offeringArn: String? = null
        override var reservationName: String? = null
        override var start: String? = null

        constructor(x: PurchaseOfferingRequest) : this() {
            this.offeringArn = x.offeringArn
            this.reservationName = x.reservationName
            this.start = x.start
        }

        override fun build(): PurchaseOfferingRequest = PurchaseOfferingRequest(this)
        override fun offeringArn(offeringArn: String): FluentBuilder = apply { this.offeringArn = offeringArn }
        override fun reservationName(reservationName: String): FluentBuilder = apply { this.reservationName = reservationName }
        override fun start(start: String): FluentBuilder = apply { this.start = start }
    }
}
