// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The definition of a media stream that you want to associate with the source.
 */
class MediaStreamSourceConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    val encodingName: EncodingName? = builder.encodingName
    /**
     * The transport parameters that you want to associate with the media stream.
     */
    val inputConfigurations: List<InputConfigurationRequest>? = builder.inputConfigurations
    /**
     * The name of the media stream.
     */
    val mediaStreamName: String? = builder.mediaStreamName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MediaStreamSourceConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamSourceConfigurationRequest(")
        append("encodingName=$encodingName,")
        append("inputConfigurations=$inputConfigurations,")
        append("mediaStreamName=$mediaStreamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encodingName?.hashCode() ?: 0
        result = 31 * result + (inputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MediaStreamSourceConfigurationRequest

        if (encodingName != other.encodingName) return false
        if (inputConfigurations != other.inputConfigurations) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MediaStreamSourceConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MediaStreamSourceConfigurationRequest
        /**
         * The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        fun encodingName(encodingName: EncodingName): FluentBuilder
        /**
         * The transport parameters that you want to associate with the media stream.
         */
        fun inputConfigurations(inputConfigurations: List<InputConfigurationRequest>): FluentBuilder
        /**
         * The name of the media stream.
         */
        fun mediaStreamName(mediaStreamName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        var encodingName: EncodingName?
        /**
         * The transport parameters that you want to associate with the media stream.
         */
        var inputConfigurations: List<InputConfigurationRequest>?
        /**
         * The name of the media stream.
         */
        var mediaStreamName: String?

        fun build(): MediaStreamSourceConfigurationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var encodingName: EncodingName? = null
        override var inputConfigurations: List<InputConfigurationRequest>? = null
        override var mediaStreamName: String? = null

        constructor(x: MediaStreamSourceConfigurationRequest) : this() {
            this.encodingName = x.encodingName
            this.inputConfigurations = x.inputConfigurations
            this.mediaStreamName = x.mediaStreamName
        }

        override fun build(): MediaStreamSourceConfigurationRequest = MediaStreamSourceConfigurationRequest(this)
        override fun encodingName(encodingName: EncodingName): FluentBuilder = apply { this.encodingName = encodingName }
        override fun inputConfigurations(inputConfigurations: List<InputConfigurationRequest>): FluentBuilder = apply { this.inputConfigurations = inputConfigurations }
        override fun mediaStreamName(mediaStreamName: String): FluentBuilder = apply { this.mediaStreamName = mediaStreamName }
    }
}
