// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
 */
class MediaStream private constructor(builder: BuilderImpl) {
    /**
     * Attributes that are related to the media stream.
     */
    val attributes: MediaStreamAttributes? = builder.attributes
    /**
     * The sample rate for the stream. This value is measured in Hz.
     */
    val clockRate: Int? = builder.clockRate
    /**
     * A description that can help you quickly identify what your media stream is used for.
     */
    val description: String? = builder.description
    /**
     * The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
     */
    val fmt: Int? = builder.fmt
    /**
     * A unique identifier for the media stream.
     */
    val mediaStreamId: Int? = builder.mediaStreamId
    /**
     * A name that helps you distinguish one media stream from another.
     */
    val mediaStreamName: String? = builder.mediaStreamName
    /**
     * The type of media stream.
     */
    val mediaStreamType: MediaStreamType? = builder.mediaStreamType
    /**
     * The resolution of the video.
     */
    val videoFormat: String? = builder.videoFormat

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MediaStream = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStream(")
        append("attributes=$attributes,")
        append("clockRate=$clockRate,")
        append("description=$description,")
        append("fmt=$fmt,")
        append("mediaStreamId=$mediaStreamId,")
        append("mediaStreamName=$mediaStreamName,")
        append("mediaStreamType=$mediaStreamType,")
        append("videoFormat=$videoFormat)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (clockRate ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fmt ?: 0)
        result = 31 * result + (mediaStreamId ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamType?.hashCode() ?: 0)
        result = 31 * result + (videoFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MediaStream

        if (attributes != other.attributes) return false
        if (clockRate != other.clockRate) return false
        if (description != other.description) return false
        if (fmt != other.fmt) return false
        if (mediaStreamId != other.mediaStreamId) return false
        if (mediaStreamName != other.mediaStreamName) return false
        if (mediaStreamType != other.mediaStreamType) return false
        if (videoFormat != other.videoFormat) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MediaStream = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MediaStream
        /**
         * Attributes that are related to the media stream.
         */
        fun attributes(attributes: MediaStreamAttributes): FluentBuilder
        /**
         * The sample rate for the stream. This value is measured in Hz.
         */
        fun clockRate(clockRate: Int): FluentBuilder
        /**
         * A description that can help you quickly identify what your media stream is used for.
         */
        fun description(description: String): FluentBuilder
        /**
         * The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
         */
        fun fmt(fmt: Int): FluentBuilder
        /**
         * A unique identifier for the media stream.
         */
        fun mediaStreamId(mediaStreamId: Int): FluentBuilder
        /**
         * A name that helps you distinguish one media stream from another.
         */
        fun mediaStreamName(mediaStreamName: String): FluentBuilder
        /**
         * The type of media stream.
         */
        fun mediaStreamType(mediaStreamType: MediaStreamType): FluentBuilder
        /**
         * The resolution of the video.
         */
        fun videoFormat(videoFormat: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Attributes that are related to the media stream.
         */
        var attributes: MediaStreamAttributes?
        /**
         * The sample rate for the stream. This value is measured in Hz.
         */
        var clockRate: Int?
        /**
         * A description that can help you quickly identify what your media stream is used for.
         */
        var description: String?
        /**
         * The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
         */
        var fmt: Int?
        /**
         * A unique identifier for the media stream.
         */
        var mediaStreamId: Int?
        /**
         * A name that helps you distinguish one media stream from another.
         */
        var mediaStreamName: String?
        /**
         * The type of media stream.
         */
        var mediaStreamType: MediaStreamType?
        /**
         * The resolution of the video.
         */
        var videoFormat: String?

        fun build(): MediaStream
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributes] inside the given [block]
         */
        fun attributes(block: MediaStreamAttributes.DslBuilder.() -> kotlin.Unit) {
            this.attributes = MediaStreamAttributes.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attributes: MediaStreamAttributes? = null
        override var clockRate: Int? = null
        override var description: String? = null
        override var fmt: Int? = null
        override var mediaStreamId: Int? = null
        override var mediaStreamName: String? = null
        override var mediaStreamType: MediaStreamType? = null
        override var videoFormat: String? = null

        constructor(x: MediaStream) : this() {
            this.attributes = x.attributes
            this.clockRate = x.clockRate
            this.description = x.description
            this.fmt = x.fmt
            this.mediaStreamId = x.mediaStreamId
            this.mediaStreamName = x.mediaStreamName
            this.mediaStreamType = x.mediaStreamType
            this.videoFormat = x.videoFormat
        }

        override fun build(): MediaStream = MediaStream(this)
        override fun attributes(attributes: MediaStreamAttributes): FluentBuilder = apply { this.attributes = attributes }
        override fun clockRate(clockRate: Int): FluentBuilder = apply { this.clockRate = clockRate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun fmt(fmt: Int): FluentBuilder = apply { this.fmt = fmt }
        override fun mediaStreamId(mediaStreamId: Int): FluentBuilder = apply { this.mediaStreamId = mediaStreamId }
        override fun mediaStreamName(mediaStreamName: String): FluentBuilder = apply { this.mediaStreamName = mediaStreamName }
        override fun mediaStreamType(mediaStreamType: MediaStreamType): FluentBuilder = apply { this.mediaStreamType = mediaStreamType }
        override fun videoFormat(videoFormat: String): FluentBuilder = apply { this.videoFormat = videoFormat }
    }
}
