// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
 */
class EncodingParameters private constructor(builder: BuilderImpl) {
    /**
     * A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
     */
    val compressionFactor: Double? = builder.compressionFactor
    /**
     * A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
     */
    val encoderProfile: EncoderProfile? = builder.encoderProfile

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EncodingParameters = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EncodingParameters(")
        append("compressionFactor=$compressionFactor,")
        append("encoderProfile=$encoderProfile)")
    }

    override fun hashCode(): kotlin.Int {
        var result = compressionFactor?.hashCode() ?: 0
        result = 31 * result + (encoderProfile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EncodingParameters

        if (compressionFactor != other.compressionFactor) return false
        if (encoderProfile != other.encoderProfile) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EncodingParameters = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EncodingParameters
        /**
         * A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
         */
        fun compressionFactor(compressionFactor: Double): FluentBuilder
        /**
         * A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
         */
        fun encoderProfile(encoderProfile: EncoderProfile): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
         */
        var compressionFactor: Double?
        /**
         * A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
         */
        var encoderProfile: EncoderProfile?

        fun build(): EncodingParameters
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var compressionFactor: Double? = null
        override var encoderProfile: EncoderProfile? = null

        constructor(x: EncodingParameters) : this() {
            this.compressionFactor = x.compressionFactor
            this.encoderProfile = x.encoderProfile
        }

        override fun build(): EncodingParameters = EncodingParameters(this)
        override fun compressionFactor(compressionFactor: Double): FluentBuilder = apply { this.compressionFactor = compressionFactor }
        override fun encoderProfile(encoderProfile: EncoderProfile): FluentBuilder = apply { this.encoderProfile = encoderProfile }
    }
}
