// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The transport parameters that are associated with an outbound media stream.
 */
class DestinationConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The IP address where contents of the media stream will be sent.
     */
    val destinationIp: String? = builder.destinationIp
    /**
     * The port to use when the content of the media stream is distributed to the output.
     */
    val destinationPort: Int? = builder.destinationPort
    /**
     * The VPC interface that is used for the media stream associated with the output.
     */
    val `interface`: Interface? = builder.`interface`
    /**
     * The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.
     */
    val outboundIp: String? = builder.outboundIp

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DestinationConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationConfiguration(")
        append("destinationIp=$destinationIp,")
        append("destinationPort=$destinationPort,")
        append("interface=$`interface`,")
        append("outboundIp=$outboundIp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationIp?.hashCode() ?: 0
        result = 31 * result + (destinationPort ?: 0)
        result = 31 * result + (`interface`?.hashCode() ?: 0)
        result = 31 * result + (outboundIp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DestinationConfiguration

        if (destinationIp != other.destinationIp) return false
        if (destinationPort != other.destinationPort) return false
        if (`interface` != other.`interface`) return false
        if (outboundIp != other.outboundIp) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DestinationConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DestinationConfiguration
        /**
         * The IP address where contents of the media stream will be sent.
         */
        fun destinationIp(destinationIp: String): FluentBuilder
        /**
         * The port to use when the content of the media stream is distributed to the output.
         */
        fun destinationPort(destinationPort: Int): FluentBuilder
        /**
         * The VPC interface that is used for the media stream associated with the output.
         */
        fun `interface`(`interface`: Interface): FluentBuilder
        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.
         */
        fun outboundIp(outboundIp: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IP address where contents of the media stream will be sent.
         */
        var destinationIp: String?
        /**
         * The port to use when the content of the media stream is distributed to the output.
         */
        var destinationPort: Int?
        /**
         * The VPC interface that is used for the media stream associated with the output.
         */
        var `interface`: Interface?
        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.
         */
        var outboundIp: String?

        fun build(): DestinationConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Interface] inside the given [block]
         */
        fun `interface`(block: Interface.DslBuilder.() -> kotlin.Unit) {
            this.`interface` = Interface.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationIp: String? = null
        override var destinationPort: Int? = null
        override var `interface`: Interface? = null
        override var outboundIp: String? = null

        constructor(x: DestinationConfiguration) : this() {
            this.destinationIp = x.destinationIp
            this.destinationPort = x.destinationPort
            this.`interface` = x.`interface`
            this.outboundIp = x.outboundIp
        }

        override fun build(): DestinationConfiguration = DestinationConfiguration(this)
        override fun destinationIp(destinationIp: String): FluentBuilder = apply { this.destinationIp = destinationIp }
        override fun destinationPort(destinationPort: Int): FluentBuilder = apply { this.destinationPort = destinationPort }
        override fun `interface`(`interface`: Interface): FluentBuilder = apply { this.`interface` = `interface` }
        override fun outboundIp(outboundIp: String): FluentBuilder = apply { this.outboundIp = outboundIp }
    }
}
