// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that you want to add to the flow.
 */
class AddMediaStreamRequest private constructor(builder: BuilderImpl) {
    /**
     * The attributes that you want to assign to the new media stream.
     */
    val attributes: MediaStreamAttributesRequest? = builder.attributes
    /**
     * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
     */
    val clockRate: Int? = builder.clockRate
    /**
     * A description that can help you quickly identify what your media stream is used for.
     */
    val description: String? = builder.description
    /**
     * A unique identifier for the media stream.
     */
    val mediaStreamId: Int? = builder.mediaStreamId
    /**
     * A name that helps you distinguish one media stream from another.
     */
    val mediaStreamName: String? = builder.mediaStreamName
    /**
     * The type of media stream.
     */
    val mediaStreamType: MediaStreamType? = builder.mediaStreamType
    /**
     * The resolution of the video.
     */
    val videoFormat: String? = builder.videoFormat

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AddMediaStreamRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AddMediaStreamRequest(")
        append("attributes=$attributes,")
        append("clockRate=$clockRate,")
        append("description=$description,")
        append("mediaStreamId=$mediaStreamId,")
        append("mediaStreamName=$mediaStreamName,")
        append("mediaStreamType=$mediaStreamType,")
        append("videoFormat=$videoFormat)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (clockRate ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamId ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamType?.hashCode() ?: 0)
        result = 31 * result + (videoFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AddMediaStreamRequest

        if (attributes != other.attributes) return false
        if (clockRate != other.clockRate) return false
        if (description != other.description) return false
        if (mediaStreamId != other.mediaStreamId) return false
        if (mediaStreamName != other.mediaStreamName) return false
        if (mediaStreamType != other.mediaStreamType) return false
        if (videoFormat != other.videoFormat) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AddMediaStreamRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AddMediaStreamRequest
        /**
         * The attributes that you want to assign to the new media stream.
         */
        fun attributes(attributes: MediaStreamAttributesRequest): FluentBuilder
        /**
         * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         */
        fun clockRate(clockRate: Int): FluentBuilder
        /**
         * A description that can help you quickly identify what your media stream is used for.
         */
        fun description(description: String): FluentBuilder
        /**
         * A unique identifier for the media stream.
         */
        fun mediaStreamId(mediaStreamId: Int): FluentBuilder
        /**
         * A name that helps you distinguish one media stream from another.
         */
        fun mediaStreamName(mediaStreamName: String): FluentBuilder
        /**
         * The type of media stream.
         */
        fun mediaStreamType(mediaStreamType: MediaStreamType): FluentBuilder
        /**
         * The resolution of the video.
         */
        fun videoFormat(videoFormat: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The attributes that you want to assign to the new media stream.
         */
        var attributes: MediaStreamAttributesRequest?
        /**
         * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         */
        var clockRate: Int?
        /**
         * A description that can help you quickly identify what your media stream is used for.
         */
        var description: String?
        /**
         * A unique identifier for the media stream.
         */
        var mediaStreamId: Int?
        /**
         * A name that helps you distinguish one media stream from another.
         */
        var mediaStreamName: String?
        /**
         * The type of media stream.
         */
        var mediaStreamType: MediaStreamType?
        /**
         * The resolution of the video.
         */
        var videoFormat: String?

        fun build(): AddMediaStreamRequest
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest] inside the given [block]
         */
        fun attributes(block: MediaStreamAttributesRequest.DslBuilder.() -> kotlin.Unit) {
            this.attributes = MediaStreamAttributesRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attributes: MediaStreamAttributesRequest? = null
        override var clockRate: Int? = null
        override var description: String? = null
        override var mediaStreamId: Int? = null
        override var mediaStreamName: String? = null
        override var mediaStreamType: MediaStreamType? = null
        override var videoFormat: String? = null

        constructor(x: AddMediaStreamRequest) : this() {
            this.attributes = x.attributes
            this.clockRate = x.clockRate
            this.description = x.description
            this.mediaStreamId = x.mediaStreamId
            this.mediaStreamName = x.mediaStreamName
            this.mediaStreamType = x.mediaStreamType
            this.videoFormat = x.videoFormat
        }

        override fun build(): AddMediaStreamRequest = AddMediaStreamRequest(this)
        override fun attributes(attributes: MediaStreamAttributesRequest): FluentBuilder = apply { this.attributes = attributes }
        override fun clockRate(clockRate: Int): FluentBuilder = apply { this.clockRate = clockRate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun mediaStreamId(mediaStreamId: Int): FluentBuilder = apply { this.mediaStreamId = mediaStreamId }
        override fun mediaStreamName(mediaStreamName: String): FluentBuilder = apply { this.mediaStreamName = mediaStreamName }
        override fun mediaStreamType(mediaStreamType: MediaStreamType): FluentBuilder = apply { this.mediaStreamType = mediaStreamType }
        override fun videoFormat(videoFormat: String): FluentBuilder = apply { this.videoFormat = videoFormat }
    }
}
