// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.mediaconnect.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * API for AWS Elemental MediaConnect
 */
interface MediaConnectClient : SdkClient {

    override val serviceName: String
        get() = "MediaConnect"
    /**
     * MediaConnectClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): MediaConnectClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultMediaConnectClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     */
    suspend fun addFlowMediaStreams(input: AddFlowMediaStreamsRequest): AddFlowMediaStreamsResponse

    /**
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     */
    suspend fun addFlowMediaStreams(block: AddFlowMediaStreamsRequest.DslBuilder.() -> Unit) = addFlowMediaStreams(AddFlowMediaStreamsRequest.builder().apply(block).build())

    /**
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     */
    suspend fun addFlowOutputs(input: AddFlowOutputsRequest): AddFlowOutputsResponse

    /**
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     */
    suspend fun addFlowOutputs(block: AddFlowOutputsRequest.DslBuilder.() -> Unit) = addFlowOutputs(AddFlowOutputsRequest.builder().apply(block).build())

    /**
     * Adds Sources to flow
     */
    suspend fun addFlowSources(input: AddFlowSourcesRequest): AddFlowSourcesResponse

    /**
     * Adds Sources to flow
     */
    suspend fun addFlowSources(block: AddFlowSourcesRequest.DslBuilder.() -> Unit) = addFlowSources(AddFlowSourcesRequest.builder().apply(block).build())

    /**
     * Adds VPC interfaces to flow
     */
    suspend fun addFlowVpcInterfaces(input: AddFlowVpcInterfacesRequest): AddFlowVpcInterfacesResponse

    /**
     * Adds VPC interfaces to flow
     */
    suspend fun addFlowVpcInterfaces(block: AddFlowVpcInterfacesRequest.DslBuilder.() -> Unit) = addFlowVpcInterfaces(AddFlowVpcInterfacesRequest.builder().apply(block).build())

    /**
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
     */
    suspend fun createFlow(input: CreateFlowRequest): CreateFlowResponse

    /**
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
     */
    suspend fun createFlow(block: CreateFlowRequest.DslBuilder.() -> Unit) = createFlow(CreateFlowRequest.builder().apply(block).build())

    /**
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     */
    suspend fun deleteFlow(input: DeleteFlowRequest): DeleteFlowResponse

    /**
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     */
    suspend fun deleteFlow(block: DeleteFlowRequest.DslBuilder.() -> Unit) = deleteFlow(DeleteFlowRequest.builder().apply(block).build())

    /**
     * Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     */
    suspend fun describeFlow(input: DescribeFlowRequest): DescribeFlowResponse

    /**
     * Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     */
    suspend fun describeFlow(block: DescribeFlowRequest.DslBuilder.() -> Unit) = describeFlow(DescribeFlowRequest.builder().apply(block).build())

    /**
     * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
     */
    suspend fun describeOffering(input: DescribeOfferingRequest): DescribeOfferingResponse

    /**
     * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
     */
    suspend fun describeOffering(block: DescribeOfferingRequest.DslBuilder.() -> Unit) = describeOffering(DescribeOfferingRequest.builder().apply(block).build())

    /**
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
     */
    suspend fun describeReservation(input: DescribeReservationRequest): DescribeReservationResponse

    /**
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
     */
    suspend fun describeReservation(block: DescribeReservationRequest.DslBuilder.() -> Unit) = describeReservation(DescribeReservationRequest.builder().apply(block).build())

    /**
     * Grants entitlements to an existing flow.
     */
    suspend fun grantFlowEntitlements(input: GrantFlowEntitlementsRequest): GrantFlowEntitlementsResponse

    /**
     * Grants entitlements to an existing flow.
     */
    suspend fun grantFlowEntitlements(block: GrantFlowEntitlementsRequest.DslBuilder.() -> Unit) = grantFlowEntitlements(GrantFlowEntitlementsRequest.builder().apply(block).build())

    /**
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
     */
    suspend fun listEntitlements(input: ListEntitlementsRequest): ListEntitlementsResponse

    /**
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
     */
    suspend fun listEntitlements(block: ListEntitlementsRequest.DslBuilder.() -> Unit) = listEntitlements(ListEntitlementsRequest.builder().apply(block).build())

    /**
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     */
    suspend fun listFlows(input: ListFlowsRequest): ListFlowsResponse

    /**
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     */
    suspend fun listFlows(block: ListFlowsRequest.DslBuilder.() -> Unit) = listFlows(ListFlowsRequest.builder().apply(block).build())

    /**
     * Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
     */
    suspend fun listOfferings(input: ListOfferingsRequest): ListOfferingsResponse

    /**
     * Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
     */
    suspend fun listOfferings(block: ListOfferingsRequest.DslBuilder.() -> Unit) = listOfferings(ListOfferingsRequest.builder().apply(block).build())

    /**
     * Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
     */
    suspend fun listReservations(input: ListReservationsRequest): ListReservationsResponse

    /**
     * Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
     */
    suspend fun listReservations(block: ListReservationsRequest.DslBuilder.() -> Unit) = listReservations(ListReservationsRequest.builder().apply(block).build())

    /**
     * List all tags on an AWS Elemental MediaConnect resource
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List all tags on an AWS Elemental MediaConnect resource
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
     */
    suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse

    /**
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
     */
    suspend fun purchaseOffering(block: PurchaseOfferingRequest.DslBuilder.() -> Unit) = purchaseOffering(PurchaseOfferingRequest.builder().apply(block).build())

    /**
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
     */
    suspend fun removeFlowMediaStream(input: RemoveFlowMediaStreamRequest): RemoveFlowMediaStreamResponse

    /**
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
     */
    suspend fun removeFlowMediaStream(block: RemoveFlowMediaStreamRequest.DslBuilder.() -> Unit) = removeFlowMediaStream(RemoveFlowMediaStreamRequest.builder().apply(block).build())

    /**
     * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
     */
    suspend fun removeFlowOutput(input: RemoveFlowOutputRequest): RemoveFlowOutputResponse

    /**
     * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
     */
    suspend fun removeFlowOutput(block: RemoveFlowOutputRequest.DslBuilder.() -> Unit) = removeFlowOutput(RemoveFlowOutputRequest.builder().apply(block).build())

    /**
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
     */
    suspend fun removeFlowSource(input: RemoveFlowSourceRequest): RemoveFlowSourceResponse

    /**
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
     */
    suspend fun removeFlowSource(block: RemoveFlowSourceRequest.DslBuilder.() -> Unit) = removeFlowSource(RemoveFlowSourceRequest.builder().apply(block).build())

    /**
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
     */
    suspend fun removeFlowVpcInterface(input: RemoveFlowVpcInterfaceRequest): RemoveFlowVpcInterfaceResponse

    /**
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
     */
    suspend fun removeFlowVpcInterface(block: RemoveFlowVpcInterfaceRequest.DslBuilder.() -> Unit) = removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest.builder().apply(block).build())

    /**
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
     */
    suspend fun revokeFlowEntitlement(input: RevokeFlowEntitlementRequest): RevokeFlowEntitlementResponse

    /**
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
     */
    suspend fun revokeFlowEntitlement(block: RevokeFlowEntitlementRequest.DslBuilder.() -> Unit) = revokeFlowEntitlement(RevokeFlowEntitlementRequest.builder().apply(block).build())

    /**
     * Starts a flow.
     */
    suspend fun startFlow(input: StartFlowRequest): StartFlowResponse

    /**
     * Starts a flow.
     */
    suspend fun startFlow(block: StartFlowRequest.DslBuilder.() -> Unit) = startFlow(StartFlowRequest.builder().apply(block).build())

    /**
     * Stops a flow.
     */
    suspend fun stopFlow(input: StopFlowRequest): StopFlowResponse

    /**
     * Stops a flow.
     */
    suspend fun stopFlow(block: StopFlowRequest.DslBuilder.() -> Unit) = stopFlow(StopFlowRequest.builder().apply(block).build())

    /**
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates flow
     */
    suspend fun updateFlow(input: UpdateFlowRequest): UpdateFlowResponse

    /**
     * Updates flow
     */
    suspend fun updateFlow(block: UpdateFlowRequest.DslBuilder.() -> Unit) = updateFlow(UpdateFlowRequest.builder().apply(block).build())

    /**
     * You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     */
    suspend fun updateFlowEntitlement(input: UpdateFlowEntitlementRequest): UpdateFlowEntitlementResponse

    /**
     * You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     */
    suspend fun updateFlowEntitlement(block: UpdateFlowEntitlementRequest.DslBuilder.() -> Unit) = updateFlowEntitlement(UpdateFlowEntitlementRequest.builder().apply(block).build())

    /**
     * Updates an existing media stream.
     */
    suspend fun updateFlowMediaStream(input: UpdateFlowMediaStreamRequest): UpdateFlowMediaStreamResponse

    /**
     * Updates an existing media stream.
     */
    suspend fun updateFlowMediaStream(block: UpdateFlowMediaStreamRequest.DslBuilder.() -> Unit) = updateFlowMediaStream(UpdateFlowMediaStreamRequest.builder().apply(block).build())

    /**
     * Updates an existing flow output.
     */
    suspend fun updateFlowOutput(input: UpdateFlowOutputRequest): UpdateFlowOutputResponse

    /**
     * Updates an existing flow output.
     */
    suspend fun updateFlowOutput(block: UpdateFlowOutputRequest.DslBuilder.() -> Unit) = updateFlowOutput(UpdateFlowOutputRequest.builder().apply(block).build())

    /**
     * Updates the source of a flow.
     */
    suspend fun updateFlowSource(input: UpdateFlowSourceRequest): UpdateFlowSourceResponse

    /**
     * Updates the source of a flow.
     */
    suspend fun updateFlowSource(block: UpdateFlowSourceRequest.DslBuilder.() -> Unit) = updateFlowSource(UpdateFlowSourceRequest.builder().apply(block).build())
}
