// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.region.resolveRegionForOperation
import aws.sdk.kotlin.services.mediaconnect.model.*
import aws.sdk.kotlin.services.mediaconnect.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "MediaConnect"
const val ServiceApiVersion: String = "2018-11-14"
const val SdkVersion: String = "0.7.0-alpha"

internal class DefaultMediaConnectClient(override val config: MediaConnectClient.Config) : MediaConnectClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
     */
    override suspend fun addFlowMediaStreams(input: AddFlowMediaStreamsRequest): AddFlowMediaStreamsResponse {
        val op = SdkHttpOperation.build<AddFlowMediaStreamsRequest, AddFlowMediaStreamsResponse> {
            serializer = AddFlowMediaStreamsOperationSerializer()
            deserializer = AddFlowMediaStreamsOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "AddFlowMediaStreams"
            }
        }
        registerAddFlowMediaStreamsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds outputs to an existing flow. You can create up to 50 outputs per flow.
     */
    override suspend fun addFlowOutputs(input: AddFlowOutputsRequest): AddFlowOutputsResponse {
        val op = SdkHttpOperation.build<AddFlowOutputsRequest, AddFlowOutputsResponse> {
            serializer = AddFlowOutputsOperationSerializer()
            deserializer = AddFlowOutputsOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "AddFlowOutputs"
            }
        }
        registerAddFlowOutputsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds Sources to flow
     */
    override suspend fun addFlowSources(input: AddFlowSourcesRequest): AddFlowSourcesResponse {
        val op = SdkHttpOperation.build<AddFlowSourcesRequest, AddFlowSourcesResponse> {
            serializer = AddFlowSourcesOperationSerializer()
            deserializer = AddFlowSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "AddFlowSources"
            }
        }
        registerAddFlowSourcesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds VPC interfaces to flow
     */
    override suspend fun addFlowVpcInterfaces(input: AddFlowVpcInterfacesRequest): AddFlowVpcInterfacesResponse {
        val op = SdkHttpOperation.build<AddFlowVpcInterfacesRequest, AddFlowVpcInterfacesResponse> {
            serializer = AddFlowVpcInterfacesOperationSerializer()
            deserializer = AddFlowVpcInterfacesOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "AddFlowVpcInterfaces"
            }
        }
        registerAddFlowVpcInterfacesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
     */
    override suspend fun createFlow(input: CreateFlowRequest): CreateFlowResponse {
        val op = SdkHttpOperation.build<CreateFlowRequest, CreateFlowResponse> {
            serializer = CreateFlowOperationSerializer()
            deserializer = CreateFlowOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateFlow"
            }
        }
        registerCreateFlowMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a flow. Before you can delete a flow, you must stop the flow.
     */
    override suspend fun deleteFlow(input: DeleteFlowRequest): DeleteFlowResponse {
        val op = SdkHttpOperation.build<DeleteFlowRequest, DeleteFlowResponse> {
            serializer = DeleteFlowOperationSerializer()
            deserializer = DeleteFlowOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteFlow"
            }
        }
        registerDeleteFlowMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
     */
    override suspend fun describeFlow(input: DescribeFlowRequest): DescribeFlowResponse {
        val op = SdkHttpOperation.build<DescribeFlowRequest, DescribeFlowResponse> {
            serializer = DescribeFlowOperationSerializer()
            deserializer = DescribeFlowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFlow"
            }
        }
        registerDescribeFlowMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
     */
    override suspend fun describeOffering(input: DescribeOfferingRequest): DescribeOfferingResponse {
        val op = SdkHttpOperation.build<DescribeOfferingRequest, DescribeOfferingResponse> {
            serializer = DescribeOfferingOperationSerializer()
            deserializer = DescribeOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOffering"
            }
        }
        registerDescribeOfferingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
     */
    override suspend fun describeReservation(input: DescribeReservationRequest): DescribeReservationResponse {
        val op = SdkHttpOperation.build<DescribeReservationRequest, DescribeReservationResponse> {
            serializer = DescribeReservationOperationSerializer()
            deserializer = DescribeReservationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservation"
            }
        }
        registerDescribeReservationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Grants entitlements to an existing flow.
     */
    override suspend fun grantFlowEntitlements(input: GrantFlowEntitlementsRequest): GrantFlowEntitlementsResponse {
        val op = SdkHttpOperation.build<GrantFlowEntitlementsRequest, GrantFlowEntitlementsResponse> {
            serializer = GrantFlowEntitlementsOperationSerializer()
            deserializer = GrantFlowEntitlementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GrantFlowEntitlements"
            }
        }
        registerGrantFlowEntitlementsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
     */
    override suspend fun listEntitlements(input: ListEntitlementsRequest): ListEntitlementsResponse {
        val op = SdkHttpOperation.build<ListEntitlementsRequest, ListEntitlementsResponse> {
            serializer = ListEntitlementsOperationSerializer()
            deserializer = ListEntitlementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEntitlements"
            }
        }
        registerListEntitlementsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays a list of flows that are associated with this account. This request returns a paginated result.
     */
    override suspend fun listFlows(input: ListFlowsRequest): ListFlowsResponse {
        val op = SdkHttpOperation.build<ListFlowsRequest, ListFlowsResponse> {
            serializer = ListFlowsOperationSerializer()
            deserializer = ListFlowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFlows"
            }
        }
        registerListFlowsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
     */
    override suspend fun listOfferings(input: ListOfferingsRequest): ListOfferingsResponse {
        val op = SdkHttpOperation.build<ListOfferingsRequest, ListOfferingsResponse> {
            serializer = ListOfferingsOperationSerializer()
            deserializer = ListOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOfferings"
            }
        }
        registerListOfferingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
     */
    override suspend fun listReservations(input: ListReservationsRequest): ListReservationsResponse {
        val op = SdkHttpOperation.build<ListReservationsRequest, ListReservationsResponse> {
            serializer = ListReservationsOperationSerializer()
            deserializer = ListReservationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReservations"
            }
        }
        registerListReservationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * List all tags on an AWS Elemental MediaConnect resource
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
     */
    override suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseOfferingRequest, PurchaseOfferingResponse> {
            serializer = PurchaseOfferingOperationSerializer()
            deserializer = PurchaseOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PurchaseOffering"
            }
        }
        registerPurchaseOfferingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
     */
    override suspend fun removeFlowMediaStream(input: RemoveFlowMediaStreamRequest): RemoveFlowMediaStreamResponse {
        val op = SdkHttpOperation.build<RemoveFlowMediaStreamRequest, RemoveFlowMediaStreamResponse> {
            serializer = RemoveFlowMediaStreamOperationSerializer()
            deserializer = RemoveFlowMediaStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveFlowMediaStream"
            }
        }
        registerRemoveFlowMediaStreamMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
     */
    override suspend fun removeFlowOutput(input: RemoveFlowOutputRequest): RemoveFlowOutputResponse {
        val op = SdkHttpOperation.build<RemoveFlowOutputRequest, RemoveFlowOutputResponse> {
            serializer = RemoveFlowOutputOperationSerializer()
            deserializer = RemoveFlowOutputOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "RemoveFlowOutput"
            }
        }
        registerRemoveFlowOutputMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
     */
    override suspend fun removeFlowSource(input: RemoveFlowSourceRequest): RemoveFlowSourceResponse {
        val op = SdkHttpOperation.build<RemoveFlowSourceRequest, RemoveFlowSourceResponse> {
            serializer = RemoveFlowSourceOperationSerializer()
            deserializer = RemoveFlowSourceOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "RemoveFlowSource"
            }
        }
        registerRemoveFlowSourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
     */
    override suspend fun removeFlowVpcInterface(input: RemoveFlowVpcInterfaceRequest): RemoveFlowVpcInterfaceResponse {
        val op = SdkHttpOperation.build<RemoveFlowVpcInterfaceRequest, RemoveFlowVpcInterfaceResponse> {
            serializer = RemoveFlowVpcInterfaceOperationSerializer()
            deserializer = RemoveFlowVpcInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveFlowVpcInterface"
            }
        }
        registerRemoveFlowVpcInterfaceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
     */
    override suspend fun revokeFlowEntitlement(input: RevokeFlowEntitlementRequest): RevokeFlowEntitlementResponse {
        val op = SdkHttpOperation.build<RevokeFlowEntitlementRequest, RevokeFlowEntitlementResponse> {
            serializer = RevokeFlowEntitlementOperationSerializer()
            deserializer = RevokeFlowEntitlementOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "RevokeFlowEntitlement"
            }
        }
        registerRevokeFlowEntitlementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a flow.
     */
    override suspend fun startFlow(input: StartFlowRequest): StartFlowResponse {
        val op = SdkHttpOperation.build<StartFlowRequest, StartFlowResponse> {
            serializer = StartFlowOperationSerializer()
            deserializer = StartFlowOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "StartFlow"
            }
        }
        registerStartFlowMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Stops a flow.
     */
    override suspend fun stopFlow(input: StopFlowRequest): StopFlowResponse {
        val op = SdkHttpOperation.build<StopFlowRequest, StopFlowResponse> {
            serializer = StopFlowOperationSerializer()
            deserializer = StopFlowOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "StopFlow"
            }
        }
        registerStopFlowMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes specified tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates flow
     */
    override suspend fun updateFlow(input: UpdateFlowRequest): UpdateFlowResponse {
        val op = SdkHttpOperation.build<UpdateFlowRequest, UpdateFlowResponse> {
            serializer = UpdateFlowOperationSerializer()
            deserializer = UpdateFlowOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateFlow"
            }
        }
        registerUpdateFlowMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
     */
    override suspend fun updateFlowEntitlement(input: UpdateFlowEntitlementRequest): UpdateFlowEntitlementResponse {
        val op = SdkHttpOperation.build<UpdateFlowEntitlementRequest, UpdateFlowEntitlementResponse> {
            serializer = UpdateFlowEntitlementOperationSerializer()
            deserializer = UpdateFlowEntitlementOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateFlowEntitlement"
            }
        }
        registerUpdateFlowEntitlementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing media stream.
     */
    override suspend fun updateFlowMediaStream(input: UpdateFlowMediaStreamRequest): UpdateFlowMediaStreamResponse {
        val op = SdkHttpOperation.build<UpdateFlowMediaStreamRequest, UpdateFlowMediaStreamResponse> {
            serializer = UpdateFlowMediaStreamOperationSerializer()
            deserializer = UpdateFlowMediaStreamOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateFlowMediaStream"
            }
        }
        registerUpdateFlowMediaStreamMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing flow output.
     */
    override suspend fun updateFlowOutput(input: UpdateFlowOutputRequest): UpdateFlowOutputResponse {
        val op = SdkHttpOperation.build<UpdateFlowOutputRequest, UpdateFlowOutputResponse> {
            serializer = UpdateFlowOutputOperationSerializer()
            deserializer = UpdateFlowOutputOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateFlowOutput"
            }
        }
        registerUpdateFlowOutputMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the source of a flow.
     */
    override suspend fun updateFlowSource(input: UpdateFlowSourceRequest): UpdateFlowSourceResponse {
        val op = SdkHttpOperation.build<UpdateFlowSourceRequest, UpdateFlowSourceResponse> {
            serializer = UpdateFlowSourceOperationSerializer()
            deserializer = UpdateFlowSourceOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateFlowSource"
            }
        }
        registerUpdateFlowSourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
