// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Desired VPC Interface for a Flow
 */
class VpcInterfaceRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the VPC Interface. This value must be unique within the current flow.
     */
    val name: String? = builder.name
    /**
     * The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
     */
    val networkInterfaceType: NetworkInterfaceType? = builder.networkInterfaceType
    /**
     * Role Arn MediaConnect can assumes to create ENIs in customer's account
     */
    val roleArn: String? = builder.roleArn
    /**
     * Security Group IDs to be used on ENI.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Subnet must be in the AZ of the Flow
     */
    val subnetId: String? = builder.subnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcInterfaceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcInterfaceRequest(")
        append("name=$name,")
        append("networkInterfaceType=$networkInterfaceType,")
        append("roleArn=$roleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceType?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcInterfaceRequest

        if (name != other.name) return false
        if (networkInterfaceType != other.networkInterfaceType) return false
        if (roleArn != other.roleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcInterfaceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcInterfaceRequest
        /**
         * The name of the VPC Interface. This value must be unique within the current flow.
         */
        fun name(name: String): FluentBuilder
        /**
         * The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
         */
        fun networkInterfaceType(networkInterfaceType: NetworkInterfaceType): FluentBuilder
        /**
         * Role Arn MediaConnect can assumes to create ENIs in customer's account
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * Security Group IDs to be used on ENI.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * Subnet must be in the AZ of the Flow
         */
        fun subnetId(subnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the VPC Interface. This value must be unique within the current flow.
         */
        var name: String?
        /**
         * The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
         */
        var networkInterfaceType: NetworkInterfaceType?
        /**
         * Role Arn MediaConnect can assumes to create ENIs in customer's account
         */
        var roleArn: String?
        /**
         * Security Group IDs to be used on ENI.
         */
        var securityGroupIds: List<String>?
        /**
         * Subnet must be in the AZ of the Flow
         */
        var subnetId: String?

        fun build(): VpcInterfaceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null
        override var networkInterfaceType: NetworkInterfaceType? = null
        override var roleArn: String? = null
        override var securityGroupIds: List<String>? = null
        override var subnetId: String? = null

        constructor(x: VpcInterfaceRequest) : this() {
            this.name = x.name
            this.networkInterfaceType = x.networkInterfaceType
            this.roleArn = x.roleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetId = x.subnetId
        }

        override fun build(): VpcInterfaceRequest = VpcInterfaceRequest(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun networkInterfaceType(networkInterfaceType: NetworkInterfaceType): FluentBuilder = apply { this.networkInterfaceType = networkInterfaceType }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
    }
}
