// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for a VPC Source.
 */
class VpcInterface private constructor(builder: BuilderImpl) {
    /**
     * Immutable and has to be a unique against other VpcInterfaces in this Flow
     */
    val name: String? = builder.name
    /**
     * IDs of the network interfaces created in customer's account by MediaConnect.
     */
    val networkInterfaceIds: List<String>? = builder.networkInterfaceIds
    /**
     * The type of network interface.
     */
    val networkInterfaceType: NetworkInterfaceType? = builder.networkInterfaceType
    /**
     * Role Arn MediaConnect can assumes to create ENIs in customer's account
     */
    val roleArn: String? = builder.roleArn
    /**
     * Security Group IDs to be used on ENI.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Subnet must be in the AZ of the Flow
     */
    val subnetId: String? = builder.subnetId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcInterface = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcInterface(")
        append("name=$name,")
        append("networkInterfaceIds=$networkInterfaceIds,")
        append("networkInterfaceType=$networkInterfaceType,")
        append("roleArn=$roleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (networkInterfaceIds?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceType?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcInterface

        if (name != other.name) return false
        if (networkInterfaceIds != other.networkInterfaceIds) return false
        if (networkInterfaceType != other.networkInterfaceType) return false
        if (roleArn != other.roleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcInterface = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcInterface
        /**
         * Immutable and has to be a unique against other VpcInterfaces in this Flow
         */
        fun name(name: String): FluentBuilder
        /**
         * IDs of the network interfaces created in customer's account by MediaConnect.
         */
        fun networkInterfaceIds(networkInterfaceIds: List<String>): FluentBuilder
        /**
         * The type of network interface.
         */
        fun networkInterfaceType(networkInterfaceType: NetworkInterfaceType): FluentBuilder
        /**
         * Role Arn MediaConnect can assumes to create ENIs in customer's account
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * Security Group IDs to be used on ENI.
         */
        fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder
        /**
         * Subnet must be in the AZ of the Flow
         */
        fun subnetId(subnetId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Immutable and has to be a unique against other VpcInterfaces in this Flow
         */
        var name: String?
        /**
         * IDs of the network interfaces created in customer's account by MediaConnect.
         */
        var networkInterfaceIds: List<String>?
        /**
         * The type of network interface.
         */
        var networkInterfaceType: NetworkInterfaceType?
        /**
         * Role Arn MediaConnect can assumes to create ENIs in customer's account
         */
        var roleArn: String?
        /**
         * Security Group IDs to be used on ENI.
         */
        var securityGroupIds: List<String>?
        /**
         * Subnet must be in the AZ of the Flow
         */
        var subnetId: String?

        fun build(): VpcInterface
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null
        override var networkInterfaceIds: List<String>? = null
        override var networkInterfaceType: NetworkInterfaceType? = null
        override var roleArn: String? = null
        override var securityGroupIds: List<String>? = null
        override var subnetId: String? = null

        constructor(x: VpcInterface) : this() {
            this.name = x.name
            this.networkInterfaceIds = x.networkInterfaceIds
            this.networkInterfaceType = x.networkInterfaceType
            this.roleArn = x.roleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetId = x.subnetId
        }

        override fun build(): VpcInterface = VpcInterface(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun networkInterfaceIds(networkInterfaceIds: List<String>): FluentBuilder = apply { this.networkInterfaceIds = networkInterfaceIds }
        override fun networkInterfaceType(networkInterfaceType: NetworkInterfaceType): FluentBuilder = apply { this.networkInterfaceType = networkInterfaceType }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun securityGroupIds(securityGroupIds: List<String>): FluentBuilder = apply { this.securityGroupIds = securityGroupIds }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
    }
}
