// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The fields that you want to update in the output.
 */
class UpdateFlowOutputRequest private constructor(builder: BuilderImpl) {
    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    val cidrAllowList: List<String>? = builder.cidrAllowList
    /**
     * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
     */
    val description: String? = builder.description
    /**
     * The IP address where you want to send the output.
     */
    val destination: String? = builder.destination
    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    val encryption: UpdateEncryption? = builder.encryption
    /**
     * The flow that is associated with the output that you want to update.
     */
    val flowArn: String? = builder.flowArn
    /**
     * The maximum latency in milliseconds for Zixi-based streams.
     */
    val maxLatency: Int? = builder.maxLatency
    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     */
    val mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = builder.mediaStreamOutputConfigurations
    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     */
    val minLatency: Int? = builder.minLatency
    /**
     * The ARN of the output that you want to update.
     */
    val outputArn: String? = builder.outputArn
    /**
     * The port to use when content is distributed to this output.
     */
    val port: Int? = builder.port
    /**
     * The protocol to use for the output.
     */
    val protocol: Protocol? = builder.protocol
    /**
     * The remote ID for the Zixi-pull stream.
     */
    val remoteId: String? = builder.remoteId
    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    val smoothingLatency: Int? = builder.smoothingLatency
    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    val streamId: String? = builder.streamId
    /**
     * The name of the VPC interface attachment to use for this output.
     */
    val vpcInterfaceAttachment: VpcInterfaceAttachment? = builder.vpcInterfaceAttachment

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFlowOutputRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFlowOutputRequest(")
        append("cidrAllowList=$cidrAllowList,")
        append("description=$description,")
        append("destination=$destination,")
        append("encryption=$encryption,")
        append("flowArn=$flowArn,")
        append("maxLatency=$maxLatency,")
        append("mediaStreamOutputConfigurations=$mediaStreamOutputConfigurations,")
        append("minLatency=$minLatency,")
        append("outputArn=$outputArn,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("remoteId=$remoteId,")
        append("smoothingLatency=$smoothingLatency,")
        append("streamId=$streamId,")
        append("vpcInterfaceAttachment=$vpcInterfaceAttachment)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrAllowList?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (maxLatency ?: 0)
        result = 31 * result + (mediaStreamOutputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (minLatency ?: 0)
        result = 31 * result + (outputArn?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (remoteId?.hashCode() ?: 0)
        result = 31 * result + (smoothingLatency ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceAttachment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFlowOutputRequest

        if (cidrAllowList != other.cidrAllowList) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (encryption != other.encryption) return false
        if (flowArn != other.flowArn) return false
        if (maxLatency != other.maxLatency) return false
        if (mediaStreamOutputConfigurations != other.mediaStreamOutputConfigurations) return false
        if (minLatency != other.minLatency) return false
        if (outputArn != other.outputArn) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (remoteId != other.remoteId) return false
        if (smoothingLatency != other.smoothingLatency) return false
        if (streamId != other.streamId) return false
        if (vpcInterfaceAttachment != other.vpcInterfaceAttachment) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFlowOutputRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFlowOutputRequest
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        fun cidrAllowList(cidrAllowList: List<String>): FluentBuilder
        /**
         * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
         */
        fun description(description: String): FluentBuilder
        /**
         * The IP address where you want to send the output.
         */
        fun destination(destination: String): FluentBuilder
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        fun encryption(encryption: UpdateEncryption): FluentBuilder
        /**
         * The flow that is associated with the output that you want to update.
         */
        fun flowArn(flowArn: String): FluentBuilder
        /**
         * The maximum latency in milliseconds for Zixi-based streams.
         */
        fun maxLatency(maxLatency: Int): FluentBuilder
        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         */
        fun mediaStreamOutputConfigurations(mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>): FluentBuilder
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        fun minLatency(minLatency: Int): FluentBuilder
        /**
         * The ARN of the output that you want to update.
         */
        fun outputArn(outputArn: String): FluentBuilder
        /**
         * The port to use when content is distributed to this output.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The protocol to use for the output.
         */
        fun protocol(protocol: Protocol): FluentBuilder
        /**
         * The remote ID for the Zixi-pull stream.
         */
        fun remoteId(remoteId: String): FluentBuilder
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        fun smoothingLatency(smoothingLatency: Int): FluentBuilder
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        fun streamId(streamId: String): FluentBuilder
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        fun vpcInterfaceAttachment(vpcInterfaceAttachment: VpcInterfaceAttachment): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         */
        var cidrAllowList: List<String>?
        /**
         * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
         */
        var description: String?
        /**
         * The IP address where you want to send the output.
         */
        var destination: String?
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        var encryption: UpdateEncryption?
        /**
         * The flow that is associated with the output that you want to update.
         */
        var flowArn: String?
        /**
         * The maximum latency in milliseconds for Zixi-based streams.
         */
        var maxLatency: Int?
        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         */
        var mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>?
        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         */
        var minLatency: Int?
        /**
         * The ARN of the output that you want to update.
         */
        var outputArn: String?
        /**
         * The port to use when content is distributed to this output.
         */
        var port: Int?
        /**
         * The protocol to use for the output.
         */
        var protocol: Protocol?
        /**
         * The remote ID for the Zixi-pull stream.
         */
        var remoteId: String?
        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         */
        var smoothingLatency: Int?
        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         */
        var streamId: String?
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        var vpcInterfaceAttachment: VpcInterfaceAttachment?

        fun build(): UpdateFlowOutputRequest
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption] inside the given [block]
         */
        fun encryption(block: UpdateEncryption.DslBuilder.() -> kotlin.Unit) {
            this.encryption = UpdateEncryption.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment] inside the given [block]
         */
        fun vpcInterfaceAttachment(block: VpcInterfaceAttachment.DslBuilder.() -> kotlin.Unit) {
            this.vpcInterfaceAttachment = VpcInterfaceAttachment.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrAllowList: List<String>? = null
        override var description: String? = null
        override var destination: String? = null
        override var encryption: UpdateEncryption? = null
        override var flowArn: String? = null
        override var maxLatency: Int? = null
        override var mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>? = null
        override var minLatency: Int? = null
        override var outputArn: String? = null
        override var port: Int? = null
        override var protocol: Protocol? = null
        override var remoteId: String? = null
        override var smoothingLatency: Int? = null
        override var streamId: String? = null
        override var vpcInterfaceAttachment: VpcInterfaceAttachment? = null

        constructor(x: UpdateFlowOutputRequest) : this() {
            this.cidrAllowList = x.cidrAllowList
            this.description = x.description
            this.destination = x.destination
            this.encryption = x.encryption
            this.flowArn = x.flowArn
            this.maxLatency = x.maxLatency
            this.mediaStreamOutputConfigurations = x.mediaStreamOutputConfigurations
            this.minLatency = x.minLatency
            this.outputArn = x.outputArn
            this.port = x.port
            this.protocol = x.protocol
            this.remoteId = x.remoteId
            this.smoothingLatency = x.smoothingLatency
            this.streamId = x.streamId
            this.vpcInterfaceAttachment = x.vpcInterfaceAttachment
        }

        override fun build(): UpdateFlowOutputRequest = UpdateFlowOutputRequest(this)
        override fun cidrAllowList(cidrAllowList: List<String>): FluentBuilder = apply { this.cidrAllowList = cidrAllowList }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun destination(destination: String): FluentBuilder = apply { this.destination = destination }
        override fun encryption(encryption: UpdateEncryption): FluentBuilder = apply { this.encryption = encryption }
        override fun flowArn(flowArn: String): FluentBuilder = apply { this.flowArn = flowArn }
        override fun maxLatency(maxLatency: Int): FluentBuilder = apply { this.maxLatency = maxLatency }
        override fun mediaStreamOutputConfigurations(mediaStreamOutputConfigurations: List<MediaStreamOutputConfigurationRequest>): FluentBuilder = apply { this.mediaStreamOutputConfigurations = mediaStreamOutputConfigurations }
        override fun minLatency(minLatency: Int): FluentBuilder = apply { this.minLatency = minLatency }
        override fun outputArn(outputArn: String): FluentBuilder = apply { this.outputArn = outputArn }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun protocol(protocol: Protocol): FluentBuilder = apply { this.protocol = protocol }
        override fun remoteId(remoteId: String): FluentBuilder = apply { this.remoteId = remoteId }
        override fun smoothingLatency(smoothingLatency: Int): FluentBuilder = apply { this.smoothingLatency = smoothingLatency }
        override fun streamId(streamId: String): FluentBuilder = apply { this.streamId = streamId }
        override fun vpcInterfaceAttachment(vpcInterfaceAttachment: VpcInterfaceAttachment): FluentBuilder = apply { this.vpcInterfaceAttachment = vpcInterfaceAttachment }
    }
}
