// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The fields that you want to update in the media stream.
 */
class UpdateFlowMediaStreamRequest private constructor(builder: BuilderImpl) {
    /**
     * The attributes that you want to assign to the media stream.
     */
    val attributes: MediaStreamAttributesRequest? = builder.attributes
    /**
     * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
     */
    val clockRate: Int? = builder.clockRate
    /**
     * Description
     */
    val description: String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    val flowArn: String? = builder.flowArn
    /**
     * The name of the media stream that you want to update.
     */
    val mediaStreamName: String? = builder.mediaStreamName
    /**
     * The type of media stream.
     */
    val mediaStreamType: MediaStreamType? = builder.mediaStreamType
    /**
     * The resolution of the video.
     */
    val videoFormat: String? = builder.videoFormat

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFlowMediaStreamRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFlowMediaStreamRequest(")
        append("attributes=$attributes,")
        append("clockRate=$clockRate,")
        append("description=$description,")
        append("flowArn=$flowArn,")
        append("mediaStreamName=$mediaStreamName,")
        append("mediaStreamType=$mediaStreamType,")
        append("videoFormat=$videoFormat)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (clockRate ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamType?.hashCode() ?: 0)
        result = 31 * result + (videoFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFlowMediaStreamRequest

        if (attributes != other.attributes) return false
        if (clockRate != other.clockRate) return false
        if (description != other.description) return false
        if (flowArn != other.flowArn) return false
        if (mediaStreamName != other.mediaStreamName) return false
        if (mediaStreamType != other.mediaStreamType) return false
        if (videoFormat != other.videoFormat) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFlowMediaStreamRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFlowMediaStreamRequest
        /**
         * The attributes that you want to assign to the media stream.
         */
        fun attributes(attributes: MediaStreamAttributesRequest): FluentBuilder
        /**
         * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         */
        fun clockRate(clockRate: Int): FluentBuilder
        /**
         * Description
         */
        fun description(description: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the flow.
         */
        fun flowArn(flowArn: String): FluentBuilder
        /**
         * The name of the media stream that you want to update.
         */
        fun mediaStreamName(mediaStreamName: String): FluentBuilder
        /**
         * The type of media stream.
         */
        fun mediaStreamType(mediaStreamType: MediaStreamType): FluentBuilder
        /**
         * The resolution of the video.
         */
        fun videoFormat(videoFormat: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The attributes that you want to assign to the media stream.
         */
        var attributes: MediaStreamAttributesRequest?
        /**
         * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         */
        var clockRate: Int?
        /**
         * Description
         */
        var description: String?
        /**
         * The Amazon Resource Name (ARN) of the flow.
         */
        var flowArn: String?
        /**
         * The name of the media stream that you want to update.
         */
        var mediaStreamName: String?
        /**
         * The type of media stream.
         */
        var mediaStreamType: MediaStreamType?
        /**
         * The resolution of the video.
         */
        var videoFormat: String?

        fun build(): UpdateFlowMediaStreamRequest
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.MediaStreamAttributesRequest] inside the given [block]
         */
        fun attributes(block: MediaStreamAttributesRequest.DslBuilder.() -> kotlin.Unit) {
            this.attributes = MediaStreamAttributesRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attributes: MediaStreamAttributesRequest? = null
        override var clockRate: Int? = null
        override var description: String? = null
        override var flowArn: String? = null
        override var mediaStreamName: String? = null
        override var mediaStreamType: MediaStreamType? = null
        override var videoFormat: String? = null

        constructor(x: UpdateFlowMediaStreamRequest) : this() {
            this.attributes = x.attributes
            this.clockRate = x.clockRate
            this.description = x.description
            this.flowArn = x.flowArn
            this.mediaStreamName = x.mediaStreamName
            this.mediaStreamType = x.mediaStreamType
            this.videoFormat = x.videoFormat
        }

        override fun build(): UpdateFlowMediaStreamRequest = UpdateFlowMediaStreamRequest(this)
        override fun attributes(attributes: MediaStreamAttributesRequest): FluentBuilder = apply { this.attributes = attributes }
        override fun clockRate(clockRate: Int): FluentBuilder = apply { this.clockRate = clockRate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun flowArn(flowArn: String): FluentBuilder = apply { this.flowArn = flowArn }
        override fun mediaStreamName(mediaStreamName: String): FluentBuilder = apply { this.mediaStreamName = mediaStreamName }
        override fun mediaStreamType(mediaStreamType: MediaStreamType): FluentBuilder = apply { this.mediaStreamType = mediaStreamType }
        override fun videoFormat(videoFormat: String): FluentBuilder = apply { this.videoFormat = videoFormat }
    }
}
