// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The entitlement fields that you want to update.
 */
class UpdateFlowEntitlementRequest private constructor(builder: BuilderImpl) {
    /**
     * A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
     */
    val description: String? = builder.description
    /**
     * The type of encryption that will be used on the output associated with this entitlement.
     */
    val encryption: UpdateEncryption? = builder.encryption
    /**
     * The ARN of the entitlement that you want to update.
     */
    val entitlementArn: String? = builder.entitlementArn
    /**
     * An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
     */
    val entitlementStatus: EntitlementStatus? = builder.entitlementStatus
    /**
     * The flow that is associated with the entitlement that you want to update.
     */
    val flowArn: String? = builder.flowArn
    /**
     * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
     */
    val subscribers: List<String>? = builder.subscribers

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFlowEntitlementRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFlowEntitlementRequest(")
        append("description=$description,")
        append("encryption=$encryption,")
        append("entitlementArn=$entitlementArn,")
        append("entitlementStatus=$entitlementStatus,")
        append("flowArn=$flowArn,")
        append("subscribers=$subscribers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (entitlementStatus?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (subscribers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFlowEntitlementRequest

        if (description != other.description) return false
        if (encryption != other.encryption) return false
        if (entitlementArn != other.entitlementArn) return false
        if (entitlementStatus != other.entitlementStatus) return false
        if (flowArn != other.flowArn) return false
        if (subscribers != other.subscribers) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFlowEntitlementRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFlowEntitlementRequest
        /**
         * A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
         */
        fun description(description: String): FluentBuilder
        /**
         * The type of encryption that will be used on the output associated with this entitlement.
         */
        fun encryption(encryption: UpdateEncryption): FluentBuilder
        /**
         * The ARN of the entitlement that you want to update.
         */
        fun entitlementArn(entitlementArn: String): FluentBuilder
        /**
         * An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
         */
        fun entitlementStatus(entitlementStatus: EntitlementStatus): FluentBuilder
        /**
         * The flow that is associated with the entitlement that you want to update.
         */
        fun flowArn(flowArn: String): FluentBuilder
        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
         */
        fun subscribers(subscribers: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
         */
        var description: String?
        /**
         * The type of encryption that will be used on the output associated with this entitlement.
         */
        var encryption: UpdateEncryption?
        /**
         * The ARN of the entitlement that you want to update.
         */
        var entitlementArn: String?
        /**
         * An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
         */
        var entitlementStatus: EntitlementStatus?
        /**
         * The flow that is associated with the entitlement that you want to update.
         */
        var flowArn: String?
        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
         */
        var subscribers: List<String>?

        fun build(): UpdateFlowEntitlementRequest
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption] inside the given [block]
         */
        fun encryption(block: UpdateEncryption.DslBuilder.() -> kotlin.Unit) {
            this.encryption = UpdateEncryption.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var encryption: UpdateEncryption? = null
        override var entitlementArn: String? = null
        override var entitlementStatus: EntitlementStatus? = null
        override var flowArn: String? = null
        override var subscribers: List<String>? = null

        constructor(x: UpdateFlowEntitlementRequest) : this() {
            this.description = x.description
            this.encryption = x.encryption
            this.entitlementArn = x.entitlementArn
            this.entitlementStatus = x.entitlementStatus
            this.flowArn = x.flowArn
            this.subscribers = x.subscribers
        }

        override fun build(): UpdateFlowEntitlementRequest = UpdateFlowEntitlementRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun encryption(encryption: UpdateEncryption): FluentBuilder = apply { this.encryption = encryption }
        override fun entitlementArn(entitlementArn: String): FluentBuilder = apply { this.entitlementArn = entitlementArn }
        override fun entitlementStatus(entitlementStatus: EntitlementStatus): FluentBuilder = apply { this.entitlementStatus = entitlementStatus }
        override fun flowArn(flowArn: String): FluentBuilder = apply { this.flowArn = flowArn }
        override fun subscribers(subscribers: List<String>): FluentBuilder = apply { this.subscribers = subscribers }
    }
}
