// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
 */
class Reservation private constructor(builder: BuilderImpl) {
    /**
     * The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
     */
    val currencyCode: String? = builder.currencyCode
    /**
     * The length of time that this reservation is active. MediaConnect defines this value in the offering.
     */
    val duration: Int? = builder.duration
    /**
     * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
     */
    val durationUnits: DurationUnits? = builder.durationUnits
    /**
     * The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
     */
    val end: String? = builder.end
    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     */
    val offeringArn: String? = builder.offeringArn
    /**
     * A description of the offering. MediaConnect defines this value in the offering.
     */
    val offeringDescription: String? = builder.offeringDescription
    /**
     * The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
     */
    val pricePerUnit: String? = builder.pricePerUnit
    /**
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
     */
    val priceUnits: PriceUnits? = builder.priceUnits
    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
     */
    val reservationArn: String? = builder.reservationArn
    /**
     * The name that you assigned to the reservation when you purchased the offering.
     */
    val reservationName: String? = builder.reservationName
    /**
     * The status of your reservation.
     */
    val reservationState: ReservationState? = builder.reservationState
    /**
     * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
     */
    val resourceSpecification: ResourceSpecification? = builder.resourceSpecification
    /**
     * The day and time that the reservation becomes active. You set this value when you purchase the offering.
     */
    val start: String? = builder.start

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Reservation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Reservation(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("durationUnits=$durationUnits,")
        append("end=$end,")
        append("offeringArn=$offeringArn,")
        append("offeringDescription=$offeringDescription,")
        append("pricePerUnit=$pricePerUnit,")
        append("priceUnits=$priceUnits,")
        append("reservationArn=$reservationArn,")
        append("reservationName=$reservationName,")
        append("reservationState=$reservationState,")
        append("resourceSpecification=$resourceSpecification,")
        append("start=$start)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (durationUnits?.hashCode() ?: 0)
        result = 31 * result + (end?.hashCode() ?: 0)
        result = 31 * result + (offeringArn?.hashCode() ?: 0)
        result = 31 * result + (offeringDescription?.hashCode() ?: 0)
        result = 31 * result + (pricePerUnit?.hashCode() ?: 0)
        result = 31 * result + (priceUnits?.hashCode() ?: 0)
        result = 31 * result + (reservationArn?.hashCode() ?: 0)
        result = 31 * result + (reservationName?.hashCode() ?: 0)
        result = 31 * result + (reservationState?.hashCode() ?: 0)
        result = 31 * result + (resourceSpecification?.hashCode() ?: 0)
        result = 31 * result + (start?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Reservation

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (durationUnits != other.durationUnits) return false
        if (end != other.end) return false
        if (offeringArn != other.offeringArn) return false
        if (offeringDescription != other.offeringDescription) return false
        if (pricePerUnit != other.pricePerUnit) return false
        if (priceUnits != other.priceUnits) return false
        if (reservationArn != other.reservationArn) return false
        if (reservationName != other.reservationName) return false
        if (reservationState != other.reservationState) return false
        if (resourceSpecification != other.resourceSpecification) return false
        if (start != other.start) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Reservation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Reservation
        /**
         * The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
         */
        fun currencyCode(currencyCode: String): FluentBuilder
        /**
         * The length of time that this reservation is active. MediaConnect defines this value in the offering.
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
         */
        fun durationUnits(durationUnits: DurationUnits): FluentBuilder
        /**
         * The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
         */
        fun end(end: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         */
        fun offeringArn(offeringArn: String): FluentBuilder
        /**
         * A description of the offering. MediaConnect defines this value in the offering.
         */
        fun offeringDescription(offeringDescription: String): FluentBuilder
        /**
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
         */
        fun pricePerUnit(pricePerUnit: String): FluentBuilder
        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
         */
        fun priceUnits(priceUnits: PriceUnits): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
         */
        fun reservationArn(reservationArn: String): FluentBuilder
        /**
         * The name that you assigned to the reservation when you purchased the offering.
         */
        fun reservationName(reservationName: String): FluentBuilder
        /**
         * The status of your reservation.
         */
        fun reservationState(reservationState: ReservationState): FluentBuilder
        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
         */
        fun resourceSpecification(resourceSpecification: ResourceSpecification): FluentBuilder
        /**
         * The day and time that the reservation becomes active. You set this value when you purchase the offering.
         */
        fun start(start: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
         */
        var currencyCode: String?
        /**
         * The length of time that this reservation is active. MediaConnect defines this value in the offering.
         */
        var duration: Int?
        /**
         * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
         */
        var durationUnits: DurationUnits?
        /**
         * The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
         */
        var end: String?
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         */
        var offeringArn: String?
        /**
         * A description of the offering. MediaConnect defines this value in the offering.
         */
        var offeringDescription: String?
        /**
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
         */
        var pricePerUnit: String?
        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
         */
        var priceUnits: PriceUnits?
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
         */
        var reservationArn: String?
        /**
         * The name that you assigned to the reservation when you purchased the offering.
         */
        var reservationName: String?
        /**
         * The status of your reservation.
         */
        var reservationState: ReservationState?
        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
         */
        var resourceSpecification: ResourceSpecification?
        /**
         * The day and time that the reservation becomes active. You set this value when you purchase the offering.
         */
        var start: String?

        fun build(): Reservation
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification] inside the given [block]
         */
        fun resourceSpecification(block: ResourceSpecification.DslBuilder.() -> kotlin.Unit) {
            this.resourceSpecification = ResourceSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currencyCode: String? = null
        override var duration: Int? = null
        override var durationUnits: DurationUnits? = null
        override var end: String? = null
        override var offeringArn: String? = null
        override var offeringDescription: String? = null
        override var pricePerUnit: String? = null
        override var priceUnits: PriceUnits? = null
        override var reservationArn: String? = null
        override var reservationName: String? = null
        override var reservationState: ReservationState? = null
        override var resourceSpecification: ResourceSpecification? = null
        override var start: String? = null

        constructor(x: Reservation) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.durationUnits = x.durationUnits
            this.end = x.end
            this.offeringArn = x.offeringArn
            this.offeringDescription = x.offeringDescription
            this.pricePerUnit = x.pricePerUnit
            this.priceUnits = x.priceUnits
            this.reservationArn = x.reservationArn
            this.reservationName = x.reservationName
            this.reservationState = x.reservationState
            this.resourceSpecification = x.resourceSpecification
            this.start = x.start
        }

        override fun build(): Reservation = Reservation(this)
        override fun currencyCode(currencyCode: String): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun durationUnits(durationUnits: DurationUnits): FluentBuilder = apply { this.durationUnits = durationUnits }
        override fun end(end: String): FluentBuilder = apply { this.end = end }
        override fun offeringArn(offeringArn: String): FluentBuilder = apply { this.offeringArn = offeringArn }
        override fun offeringDescription(offeringDescription: String): FluentBuilder = apply { this.offeringDescription = offeringDescription }
        override fun pricePerUnit(pricePerUnit: String): FluentBuilder = apply { this.pricePerUnit = pricePerUnit }
        override fun priceUnits(priceUnits: PriceUnits): FluentBuilder = apply { this.priceUnits = priceUnits }
        override fun reservationArn(reservationArn: String): FluentBuilder = apply { this.reservationArn = reservationArn }
        override fun reservationName(reservationName: String): FluentBuilder = apply { this.reservationName = reservationName }
        override fun reservationState(reservationState: ReservationState): FluentBuilder = apply { this.reservationState = reservationState }
        override fun resourceSpecification(resourceSpecification: ResourceSpecification): FluentBuilder = apply { this.resourceSpecification = resourceSpecification }
        override fun start(start: String): FluentBuilder = apply { this.start = start }
    }
}
