// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for an output.
 */
class Output private constructor(builder: BuilderImpl) {
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    val dataTransferSubscriberFeePercent: Int? = builder.dataTransferSubscriberFeePercent
    /**
     * A description of the output.
     */
    val description: String? = builder.description
    /**
     * The address where you want to send the output.
     */
    val destination: String? = builder.destination
    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    val encryption: Encryption? = builder.encryption
    /**
     * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
     */
    val entitlementArn: String? = builder.entitlementArn
    /**
     * The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
     */
    val listenerAddress: String? = builder.listenerAddress
    /**
     * The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
     */
    val mediaLiveInputArn: String? = builder.mediaLiveInputArn
    /**
     * The configuration for each media stream that is associated with the output.
     */
    val mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>? = builder.mediaStreamOutputConfigurations
    /**
     * The name of the output. This value must be unique within the current flow.
     */
    val name: String? = builder.name
    /**
     * The ARN of the output.
     */
    val outputArn: String? = builder.outputArn
    /**
     * The port to use when content is distributed to this output.
     */
    val port: Int? = builder.port
    /**
     * Attributes related to the transport stream that are used in the output.
     */
    val transport: Transport? = builder.transport
    /**
     * The name of the VPC interface attachment to use for this output.
     */
    val vpcInterfaceAttachment: VpcInterfaceAttachment? = builder.vpcInterfaceAttachment

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Output = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Output(")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("description=$description,")
        append("destination=$destination,")
        append("encryption=$encryption,")
        append("entitlementArn=$entitlementArn,")
        append("listenerAddress=$listenerAddress,")
        append("mediaLiveInputArn=$mediaLiveInputArn,")
        append("mediaStreamOutputConfigurations=$mediaStreamOutputConfigurations,")
        append("name=$name,")
        append("outputArn=$outputArn,")
        append("port=$port,")
        append("transport=$transport,")
        append("vpcInterfaceAttachment=$vpcInterfaceAttachment)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferSubscriberFeePercent ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (listenerAddress?.hashCode() ?: 0)
        result = 31 * result + (mediaLiveInputArn?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamOutputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputArn?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (transport?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaceAttachment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Output

        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (description != other.description) return false
        if (destination != other.destination) return false
        if (encryption != other.encryption) return false
        if (entitlementArn != other.entitlementArn) return false
        if (listenerAddress != other.listenerAddress) return false
        if (mediaLiveInputArn != other.mediaLiveInputArn) return false
        if (mediaStreamOutputConfigurations != other.mediaStreamOutputConfigurations) return false
        if (name != other.name) return false
        if (outputArn != other.outputArn) return false
        if (port != other.port) return false
        if (transport != other.transport) return false
        if (vpcInterfaceAttachment != other.vpcInterfaceAttachment) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Output = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Output
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        fun dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent: Int): FluentBuilder
        /**
         * A description of the output.
         */
        fun description(description: String): FluentBuilder
        /**
         * The address where you want to send the output.
         */
        fun destination(destination: String): FluentBuilder
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        fun encryption(encryption: Encryption): FluentBuilder
        /**
         * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
         */
        fun entitlementArn(entitlementArn: String): FluentBuilder
        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
         */
        fun listenerAddress(listenerAddress: String): FluentBuilder
        /**
         * The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
         */
        fun mediaLiveInputArn(mediaLiveInputArn: String): FluentBuilder
        /**
         * The configuration for each media stream that is associated with the output.
         */
        fun mediaStreamOutputConfigurations(mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>): FluentBuilder
        /**
         * The name of the output. This value must be unique within the current flow.
         */
        fun name(name: String): FluentBuilder
        /**
         * The ARN of the output.
         */
        fun outputArn(outputArn: String): FluentBuilder
        /**
         * The port to use when content is distributed to this output.
         */
        fun port(port: Int): FluentBuilder
        /**
         * Attributes related to the transport stream that are used in the output.
         */
        fun transport(transport: Transport): FluentBuilder
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        fun vpcInterfaceAttachment(vpcInterfaceAttachment: VpcInterfaceAttachment): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        var dataTransferSubscriberFeePercent: Int?
        /**
         * A description of the output.
         */
        var description: String?
        /**
         * The address where you want to send the output.
         */
        var destination: String?
        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        var encryption: Encryption?
        /**
         * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
         */
        var entitlementArn: String?
        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
         */
        var listenerAddress: String?
        /**
         * The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
         */
        var mediaLiveInputArn: String?
        /**
         * The configuration for each media stream that is associated with the output.
         */
        var mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>?
        /**
         * The name of the output. This value must be unique within the current flow.
         */
        var name: String?
        /**
         * The ARN of the output.
         */
        var outputArn: String?
        /**
         * The port to use when content is distributed to this output.
         */
        var port: Int?
        /**
         * Attributes related to the transport stream that are used in the output.
         */
        var transport: Transport?
        /**
         * The name of the VPC interface attachment to use for this output.
         */
        var vpcInterfaceAttachment: VpcInterfaceAttachment?

        fun build(): Output
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        fun encryption(block: Encryption.DslBuilder.() -> kotlin.Unit) {
            this.encryption = Encryption.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Transport] inside the given [block]
         */
        fun transport(block: Transport.DslBuilder.() -> kotlin.Unit) {
            this.transport = Transport.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.VpcInterfaceAttachment] inside the given [block]
         */
        fun vpcInterfaceAttachment(block: VpcInterfaceAttachment.DslBuilder.() -> kotlin.Unit) {
            this.vpcInterfaceAttachment = VpcInterfaceAttachment.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataTransferSubscriberFeePercent: Int? = null
        override var description: String? = null
        override var destination: String? = null
        override var encryption: Encryption? = null
        override var entitlementArn: String? = null
        override var listenerAddress: String? = null
        override var mediaLiveInputArn: String? = null
        override var mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>? = null
        override var name: String? = null
        override var outputArn: String? = null
        override var port: Int? = null
        override var transport: Transport? = null
        override var vpcInterfaceAttachment: VpcInterfaceAttachment? = null

        constructor(x: Output) : this() {
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.description = x.description
            this.destination = x.destination
            this.encryption = x.encryption
            this.entitlementArn = x.entitlementArn
            this.listenerAddress = x.listenerAddress
            this.mediaLiveInputArn = x.mediaLiveInputArn
            this.mediaStreamOutputConfigurations = x.mediaStreamOutputConfigurations
            this.name = x.name
            this.outputArn = x.outputArn
            this.port = x.port
            this.transport = x.transport
            this.vpcInterfaceAttachment = x.vpcInterfaceAttachment
        }

        override fun build(): Output = Output(this)
        override fun dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent: Int): FluentBuilder = apply { this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun destination(destination: String): FluentBuilder = apply { this.destination = destination }
        override fun encryption(encryption: Encryption): FluentBuilder = apply { this.encryption = encryption }
        override fun entitlementArn(entitlementArn: String): FluentBuilder = apply { this.entitlementArn = entitlementArn }
        override fun listenerAddress(listenerAddress: String): FluentBuilder = apply { this.listenerAddress = listenerAddress }
        override fun mediaLiveInputArn(mediaLiveInputArn: String): FluentBuilder = apply { this.mediaLiveInputArn = mediaLiveInputArn }
        override fun mediaStreamOutputConfigurations(mediaStreamOutputConfigurations: List<MediaStreamOutputConfiguration>): FluentBuilder = apply { this.mediaStreamOutputConfigurations = mediaStreamOutputConfigurations }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun outputArn(outputArn: String): FluentBuilder = apply { this.outputArn = outputArn }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun transport(transport: Transport): FluentBuilder = apply { this.transport = transport }
        override fun vpcInterfaceAttachment(vpcInterfaceAttachment: VpcInterfaceAttachment): FluentBuilder = apply { this.vpcInterfaceAttachment = vpcInterfaceAttachment }
    }
}
