// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
 */
class Offering private constructor(builder: BuilderImpl) {
    /**
     * The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
     */
    val currencyCode: String? = builder.currencyCode
    /**
     * The length of time that your reservation would be active.
     */
    val duration: Int? = builder.duration
    /**
     * The unit of measurement for the duration of the offering.
     */
    val durationUnits: DurationUnits? = builder.durationUnits
    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     */
    val offeringArn: String? = builder.offeringArn
    /**
     * A description of the offering.
     */
    val offeringDescription: String? = builder.offeringDescription
    /**
     * The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
     */
    val pricePerUnit: String? = builder.pricePerUnit
    /**
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
     */
    val priceUnits: PriceUnits? = builder.priceUnits
    /**
     * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
     */
    val resourceSpecification: ResourceSpecification? = builder.resourceSpecification

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Offering = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Offering(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("durationUnits=$durationUnits,")
        append("offeringArn=$offeringArn,")
        append("offeringDescription=$offeringDescription,")
        append("pricePerUnit=$pricePerUnit,")
        append("priceUnits=$priceUnits,")
        append("resourceSpecification=$resourceSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (durationUnits?.hashCode() ?: 0)
        result = 31 * result + (offeringArn?.hashCode() ?: 0)
        result = 31 * result + (offeringDescription?.hashCode() ?: 0)
        result = 31 * result + (pricePerUnit?.hashCode() ?: 0)
        result = 31 * result + (priceUnits?.hashCode() ?: 0)
        result = 31 * result + (resourceSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Offering

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (durationUnits != other.durationUnits) return false
        if (offeringArn != other.offeringArn) return false
        if (offeringDescription != other.offeringDescription) return false
        if (pricePerUnit != other.pricePerUnit) return false
        if (priceUnits != other.priceUnits) return false
        if (resourceSpecification != other.resourceSpecification) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Offering = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Offering
        /**
         * The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
         */
        fun currencyCode(currencyCode: String): FluentBuilder
        /**
         * The length of time that your reservation would be active.
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The unit of measurement for the duration of the offering.
         */
        fun durationUnits(durationUnits: DurationUnits): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         */
        fun offeringArn(offeringArn: String): FluentBuilder
        /**
         * A description of the offering.
         */
        fun offeringDescription(offeringDescription: String): FluentBuilder
        /**
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
         */
        fun pricePerUnit(pricePerUnit: String): FluentBuilder
        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
         */
        fun priceUnits(priceUnits: PriceUnits): FluentBuilder
        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
         */
        fun resourceSpecification(resourceSpecification: ResourceSpecification): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
         */
        var currencyCode: String?
        /**
         * The length of time that your reservation would be active.
         */
        var duration: Int?
        /**
         * The unit of measurement for the duration of the offering.
         */
        var durationUnits: DurationUnits?
        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         */
        var offeringArn: String?
        /**
         * A description of the offering.
         */
        var offeringDescription: String?
        /**
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
         */
        var pricePerUnit: String?
        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
         */
        var priceUnits: PriceUnits?
        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
         */
        var resourceSpecification: ResourceSpecification?

        fun build(): Offering
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.ResourceSpecification] inside the given [block]
         */
        fun resourceSpecification(block: ResourceSpecification.DslBuilder.() -> kotlin.Unit) {
            this.resourceSpecification = ResourceSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var currencyCode: String? = null
        override var duration: Int? = null
        override var durationUnits: DurationUnits? = null
        override var offeringArn: String? = null
        override var offeringDescription: String? = null
        override var pricePerUnit: String? = null
        override var priceUnits: PriceUnits? = null
        override var resourceSpecification: ResourceSpecification? = null

        constructor(x: Offering) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.durationUnits = x.durationUnits
            this.offeringArn = x.offeringArn
            this.offeringDescription = x.offeringDescription
            this.pricePerUnit = x.pricePerUnit
            this.priceUnits = x.priceUnits
            this.resourceSpecification = x.resourceSpecification
        }

        override fun build(): Offering = Offering(this)
        override fun currencyCode(currencyCode: String): FluentBuilder = apply { this.currencyCode = currencyCode }
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun durationUnits(durationUnits: DurationUnits): FluentBuilder = apply { this.durationUnits = durationUnits }
        override fun offeringArn(offeringArn: String): FluentBuilder = apply { this.offeringArn = offeringArn }
        override fun offeringDescription(offeringDescription: String): FluentBuilder = apply { this.offeringDescription = offeringDescription }
        override fun pricePerUnit(pricePerUnit: String): FluentBuilder = apply { this.pricePerUnit = pricePerUnit }
        override fun priceUnits(priceUnits: PriceUnits): FluentBuilder = apply { this.priceUnits = priceUnits }
        override fun resourceSpecification(resourceSpecification: ResourceSpecification): FluentBuilder = apply { this.resourceSpecification = resourceSpecification }
    }
}
