// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that is associated with the source, and the parameters for that association.
 */
class MediaStreamSourceConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    val encodingName: EncodingName? = builder.encodingName
    /**
     * The transport parameters that are associated with an incoming media stream.
     */
    val inputConfigurations: List<InputConfiguration>? = builder.inputConfigurations
    /**
     * The name of the media stream.
     */
    val mediaStreamName: String? = builder.mediaStreamName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MediaStreamSourceConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamSourceConfiguration(")
        append("encodingName=$encodingName,")
        append("inputConfigurations=$inputConfigurations,")
        append("mediaStreamName=$mediaStreamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encodingName?.hashCode() ?: 0
        result = 31 * result + (inputConfigurations?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MediaStreamSourceConfiguration

        if (encodingName != other.encodingName) return false
        if (inputConfigurations != other.inputConfigurations) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MediaStreamSourceConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MediaStreamSourceConfiguration
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        fun encodingName(encodingName: EncodingName): FluentBuilder
        /**
         * The transport parameters that are associated with an incoming media stream.
         */
        fun inputConfigurations(inputConfigurations: List<InputConfiguration>): FluentBuilder
        /**
         * The name of the media stream.
         */
        fun mediaStreamName(mediaStreamName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        var encodingName: EncodingName?
        /**
         * The transport parameters that are associated with an incoming media stream.
         */
        var inputConfigurations: List<InputConfiguration>?
        /**
         * The name of the media stream.
         */
        var mediaStreamName: String?

        fun build(): MediaStreamSourceConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var encodingName: EncodingName? = null
        override var inputConfigurations: List<InputConfiguration>? = null
        override var mediaStreamName: String? = null

        constructor(x: MediaStreamSourceConfiguration) : this() {
            this.encodingName = x.encodingName
            this.inputConfigurations = x.inputConfigurations
            this.mediaStreamName = x.mediaStreamName
        }

        override fun build(): MediaStreamSourceConfiguration = MediaStreamSourceConfiguration(this)
        override fun encodingName(encodingName: EncodingName): FluentBuilder = apply { this.encodingName = encodingName }
        override fun inputConfigurations(inputConfigurations: List<InputConfiguration>): FluentBuilder = apply { this.inputConfigurations = inputConfigurations }
        override fun mediaStreamName(mediaStreamName: String): FluentBuilder = apply { this.mediaStreamName = mediaStreamName }
    }
}
