// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that you want to associate with the output, and the parameters for that association.
 */
class MediaStreamOutputConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The transport parameters that you want to associate with the media stream.
     */
    val destinationConfigurations: List<DestinationConfigurationRequest>? = builder.destinationConfigurations
    /**
     * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    val encodingName: EncodingName? = builder.encodingName
    /**
     * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
     */
    val encodingParameters: EncodingParametersRequest? = builder.encodingParameters
    /**
     * The name of the media stream that is associated with the output.
     */
    val mediaStreamName: String? = builder.mediaStreamName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MediaStreamOutputConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamOutputConfigurationRequest(")
        append("destinationConfigurations=$destinationConfigurations,")
        append("encodingName=$encodingName,")
        append("encodingParameters=$encodingParameters,")
        append("mediaStreamName=$mediaStreamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfigurations?.hashCode() ?: 0
        result = 31 * result + (encodingName?.hashCode() ?: 0)
        result = 31 * result + (encodingParameters?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MediaStreamOutputConfigurationRequest

        if (destinationConfigurations != other.destinationConfigurations) return false
        if (encodingName != other.encodingName) return false
        if (encodingParameters != other.encodingParameters) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MediaStreamOutputConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MediaStreamOutputConfigurationRequest
        /**
         * The transport parameters that you want to associate with the media stream.
         */
        fun destinationConfigurations(destinationConfigurations: List<DestinationConfigurationRequest>): FluentBuilder
        /**
         * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        fun encodingName(encodingName: EncodingName): FluentBuilder
        /**
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
         */
        fun encodingParameters(encodingParameters: EncodingParametersRequest): FluentBuilder
        /**
         * The name of the media stream that is associated with the output.
         */
        fun mediaStreamName(mediaStreamName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The transport parameters that you want to associate with the media stream.
         */
        var destinationConfigurations: List<DestinationConfigurationRequest>?
        /**
         * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        var encodingName: EncodingName?
        /**
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
         */
        var encodingParameters: EncodingParametersRequest?
        /**
         * The name of the media stream that is associated with the output.
         */
        var mediaStreamName: String?

        fun build(): MediaStreamOutputConfigurationRequest
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.EncodingParametersRequest] inside the given [block]
         */
        fun encodingParameters(block: EncodingParametersRequest.DslBuilder.() -> kotlin.Unit) {
            this.encodingParameters = EncodingParametersRequest.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationConfigurations: List<DestinationConfigurationRequest>? = null
        override var encodingName: EncodingName? = null
        override var encodingParameters: EncodingParametersRequest? = null
        override var mediaStreamName: String? = null

        constructor(x: MediaStreamOutputConfigurationRequest) : this() {
            this.destinationConfigurations = x.destinationConfigurations
            this.encodingName = x.encodingName
            this.encodingParameters = x.encodingParameters
            this.mediaStreamName = x.mediaStreamName
        }

        override fun build(): MediaStreamOutputConfigurationRequest = MediaStreamOutputConfigurationRequest(this)
        override fun destinationConfigurations(destinationConfigurations: List<DestinationConfigurationRequest>): FluentBuilder = apply { this.destinationConfigurations = destinationConfigurations }
        override fun encodingName(encodingName: EncodingName): FluentBuilder = apply { this.encodingName = encodingName }
        override fun encodingParameters(encodingParameters: EncodingParametersRequest): FluentBuilder = apply { this.encodingParameters = encodingParameters }
        override fun mediaStreamName(mediaStreamName: String): FluentBuilder = apply { this.mediaStreamName = mediaStreamName }
    }
}
