// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The media stream that is associated with the output, and the parameters for that association.
 */
class MediaStreamOutputConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The transport parameters that are associated with each outbound media stream.
     */
    val destinationConfigurations: List<DestinationConfiguration>? = builder.destinationConfigurations
    /**
     * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     */
    val encodingName: EncodingName? = builder.encodingName
    /**
     * Encoding parameters
     */
    val encodingParameters: EncodingParameters? = builder.encodingParameters
    /**
     * The name of the media stream.
     */
    val mediaStreamName: String? = builder.mediaStreamName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MediaStreamOutputConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MediaStreamOutputConfiguration(")
        append("destinationConfigurations=$destinationConfigurations,")
        append("encodingName=$encodingName,")
        append("encodingParameters=$encodingParameters,")
        append("mediaStreamName=$mediaStreamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfigurations?.hashCode() ?: 0
        result = 31 * result + (encodingName?.hashCode() ?: 0)
        result = 31 * result + (encodingParameters?.hashCode() ?: 0)
        result = 31 * result + (mediaStreamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MediaStreamOutputConfiguration

        if (destinationConfigurations != other.destinationConfigurations) return false
        if (encodingName != other.encodingName) return false
        if (encodingParameters != other.encodingParameters) return false
        if (mediaStreamName != other.mediaStreamName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MediaStreamOutputConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MediaStreamOutputConfiguration
        /**
         * The transport parameters that are associated with each outbound media stream.
         */
        fun destinationConfigurations(destinationConfigurations: List<DestinationConfiguration>): FluentBuilder
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        fun encodingName(encodingName: EncodingName): FluentBuilder
        /**
         * Encoding parameters
         */
        fun encodingParameters(encodingParameters: EncodingParameters): FluentBuilder
        /**
         * The name of the media stream.
         */
        fun mediaStreamName(mediaStreamName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The transport parameters that are associated with each outbound media stream.
         */
        var destinationConfigurations: List<DestinationConfiguration>?
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         */
        var encodingName: EncodingName?
        /**
         * Encoding parameters
         */
        var encodingParameters: EncodingParameters?
        /**
         * The name of the media stream.
         */
        var mediaStreamName: String?

        fun build(): MediaStreamOutputConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.EncodingParameters] inside the given [block]
         */
        fun encodingParameters(block: EncodingParameters.DslBuilder.() -> kotlin.Unit) {
            this.encodingParameters = EncodingParameters.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var destinationConfigurations: List<DestinationConfiguration>? = null
        override var encodingName: EncodingName? = null
        override var encodingParameters: EncodingParameters? = null
        override var mediaStreamName: String? = null

        constructor(x: MediaStreamOutputConfiguration) : this() {
            this.destinationConfigurations = x.destinationConfigurations
            this.encodingName = x.encodingName
            this.encodingParameters = x.encodingParameters
            this.mediaStreamName = x.mediaStreamName
        }

        override fun build(): MediaStreamOutputConfiguration = MediaStreamOutputConfiguration(this)
        override fun destinationConfigurations(destinationConfigurations: List<DestinationConfiguration>): FluentBuilder = apply { this.destinationConfigurations = destinationConfigurations }
        override fun encodingName(encodingName: EncodingName): FluentBuilder = apply { this.encodingName = encodingName }
        override fun encodingParameters(encodingParameters: EncodingParameters): FluentBuilder = apply { this.encodingParameters = encodingParameters }
        override fun mediaStreamName(mediaStreamName: String): FluentBuilder = apply { this.mediaStreamName = mediaStreamName }
    }
}
