// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Provides a summary of a flow, including its ARN, Availability Zone, and source type.
 */
class ListedFlow private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone that the flow was created in.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * A description of the flow.
     */
    val description: String? = builder.description
    /**
     * The ARN of the flow.
     */
    val flowArn: String? = builder.flowArn
    /**
     * The name of the flow.
     */
    val name: String? = builder.name
    /**
     * The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).
     */
    val sourceType: SourceType? = builder.sourceType
    /**
     * The current status of the flow.
     */
    val status: Status? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListedFlow = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListedFlow(")
        append("availabilityZone=$availabilityZone,")
        append("description=$description,")
        append("flowArn=$flowArn,")
        append("name=$name,")
        append("sourceType=$sourceType,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListedFlow

        if (availabilityZone != other.availabilityZone) return false
        if (description != other.description) return false
        if (flowArn != other.flowArn) return false
        if (name != other.name) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListedFlow = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListedFlow
        /**
         * The Availability Zone that the flow was created in.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * A description of the flow.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ARN of the flow.
         */
        fun flowArn(flowArn: String): FluentBuilder
        /**
         * The name of the flow.
         */
        fun name(name: String): FluentBuilder
        /**
         * The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).
         */
        fun sourceType(sourceType: SourceType): FluentBuilder
        /**
         * The current status of the flow.
         */
        fun status(status: Status): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone that the flow was created in.
         */
        var availabilityZone: String?
        /**
         * A description of the flow.
         */
        var description: String?
        /**
         * The ARN of the flow.
         */
        var flowArn: String?
        /**
         * The name of the flow.
         */
        var name: String?
        /**
         * The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).
         */
        var sourceType: SourceType?
        /**
         * The current status of the flow.
         */
        var status: Status?

        fun build(): ListedFlow
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var description: String? = null
        override var flowArn: String? = null
        override var name: String? = null
        override var sourceType: SourceType? = null
        override var status: Status? = null

        constructor(x: ListedFlow) : this() {
            this.availabilityZone = x.availabilityZone
            this.description = x.description
            this.flowArn = x.flowArn
            this.name = x.name
            this.sourceType = x.sourceType
            this.status = x.status
        }

        override fun build(): ListedFlow = ListedFlow(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun flowArn(flowArn: String): FluentBuilder = apply { this.flowArn = flowArn }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun sourceType(sourceType: SourceType): FluentBuilder = apply { this.sourceType = sourceType }
        override fun status(status: Status): FluentBuilder = apply { this.status = status }
    }
}
