// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for a flow, including its source, outputs, and entitlements.
 */
class Flow private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
     */
    val description: String? = builder.description
    /**
     * The IP address from which video will be sent to output destinations.
     */
    val egressIp: String? = builder.egressIp
    /**
     * The entitlements in this flow.
     */
    val entitlements: List<Entitlement>? = builder.entitlements
    /**
     * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
     */
    val flowArn: String? = builder.flowArn
    /**
     * The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
     */
    val mediaStreams: List<MediaStream>? = builder.mediaStreams
    /**
     * The name of the flow.
     */
    val name: String? = builder.name
    /**
     * The outputs in this flow.
     */
    val outputs: List<Output>? = builder.outputs
    /**
     * The settings for the source of the flow.
     */
    val source: Source? = builder.source
    /**
     * The settings for source failover
     */
    val sourceFailoverConfig: FailoverConfig? = builder.sourceFailoverConfig
    val sources: List<Source>? = builder.sources
    /**
     * The current status of the flow.
     */
    val status: Status? = builder.status
    /**
     * The VPC Interfaces for this flow.
     */
    val vpcInterfaces: List<VpcInterface>? = builder.vpcInterfaces

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Flow = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Flow(")
        append("availabilityZone=$availabilityZone,")
        append("description=$description,")
        append("egressIp=$egressIp,")
        append("entitlements=$entitlements,")
        append("flowArn=$flowArn,")
        append("mediaStreams=$mediaStreams,")
        append("name=$name,")
        append("outputs=$outputs,")
        append("source=$source,")
        append("sourceFailoverConfig=$sourceFailoverConfig,")
        append("sources=$sources,")
        append("status=$status,")
        append("vpcInterfaces=$vpcInterfaces)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (egressIp?.hashCode() ?: 0)
        result = 31 * result + (entitlements?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (mediaStreams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceFailoverConfig?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Flow

        if (availabilityZone != other.availabilityZone) return false
        if (description != other.description) return false
        if (egressIp != other.egressIp) return false
        if (entitlements != other.entitlements) return false
        if (flowArn != other.flowArn) return false
        if (mediaStreams != other.mediaStreams) return false
        if (name != other.name) return false
        if (outputs != other.outputs) return false
        if (source != other.source) return false
        if (sourceFailoverConfig != other.sourceFailoverConfig) return false
        if (sources != other.sources) return false
        if (status != other.status) return false
        if (vpcInterfaces != other.vpcInterfaces) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Flow = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Flow
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        fun description(description: String): FluentBuilder
        /**
         * The IP address from which video will be sent to output destinations.
         */
        fun egressIp(egressIp: String): FluentBuilder
        /**
         * The entitlements in this flow.
         */
        fun entitlements(entitlements: List<Entitlement>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
         */
        fun flowArn(flowArn: String): FluentBuilder
        /**
         * The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
         */
        fun mediaStreams(mediaStreams: List<MediaStream>): FluentBuilder
        /**
         * The name of the flow.
         */
        fun name(name: String): FluentBuilder
        /**
         * The outputs in this flow.
         */
        fun outputs(outputs: List<Output>): FluentBuilder
        /**
         * The settings for the source of the flow.
         */
        fun source(source: Source): FluentBuilder
        /**
         * The settings for source failover
         */
        fun sourceFailoverConfig(sourceFailoverConfig: FailoverConfig): FluentBuilder
        fun sources(sources: List<Source>): FluentBuilder
        /**
         * The current status of the flow.
         */
        fun status(status: Status): FluentBuilder
        /**
         * The VPC Interfaces for this flow.
         */
        fun vpcInterfaces(vpcInterfaces: List<VpcInterface>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
         */
        var availabilityZone: String?
        /**
         * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
         */
        var description: String?
        /**
         * The IP address from which video will be sent to output destinations.
         */
        var egressIp: String?
        /**
         * The entitlements in this flow.
         */
        var entitlements: List<Entitlement>?
        /**
         * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
         */
        var flowArn: String?
        /**
         * The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
         */
        var mediaStreams: List<MediaStream>?
        /**
         * The name of the flow.
         */
        var name: String?
        /**
         * The outputs in this flow.
         */
        var outputs: List<Output>?
        /**
         * The settings for the source of the flow.
         */
        var source: Source?
        /**
         * The settings for source failover
         */
        var sourceFailoverConfig: FailoverConfig?
        var sources: List<Source>?
        /**
         * The current status of the flow.
         */
        var status: Status?
        /**
         * The VPC Interfaces for this flow.
         */
        var vpcInterfaces: List<VpcInterface>?

        fun build(): Flow
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Source] inside the given [block]
         */
        fun source(block: Source.DslBuilder.() -> kotlin.Unit) {
            this.source = Source.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig] inside the given [block]
         */
        fun sourceFailoverConfig(block: FailoverConfig.DslBuilder.() -> kotlin.Unit) {
            this.sourceFailoverConfig = FailoverConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var description: String? = null
        override var egressIp: String? = null
        override var entitlements: List<Entitlement>? = null
        override var flowArn: String? = null
        override var mediaStreams: List<MediaStream>? = null
        override var name: String? = null
        override var outputs: List<Output>? = null
        override var source: Source? = null
        override var sourceFailoverConfig: FailoverConfig? = null
        override var sources: List<Source>? = null
        override var status: Status? = null
        override var vpcInterfaces: List<VpcInterface>? = null

        constructor(x: Flow) : this() {
            this.availabilityZone = x.availabilityZone
            this.description = x.description
            this.egressIp = x.egressIp
            this.entitlements = x.entitlements
            this.flowArn = x.flowArn
            this.mediaStreams = x.mediaStreams
            this.name = x.name
            this.outputs = x.outputs
            this.source = x.source
            this.sourceFailoverConfig = x.sourceFailoverConfig
            this.sources = x.sources
            this.status = x.status
            this.vpcInterfaces = x.vpcInterfaces
        }

        override fun build(): Flow = Flow(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun egressIp(egressIp: String): FluentBuilder = apply { this.egressIp = egressIp }
        override fun entitlements(entitlements: List<Entitlement>): FluentBuilder = apply { this.entitlements = entitlements }
        override fun flowArn(flowArn: String): FluentBuilder = apply { this.flowArn = flowArn }
        override fun mediaStreams(mediaStreams: List<MediaStream>): FluentBuilder = apply { this.mediaStreams = mediaStreams }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun outputs(outputs: List<Output>): FluentBuilder = apply { this.outputs = outputs }
        override fun source(source: Source): FluentBuilder = apply { this.source = source }
        override fun sourceFailoverConfig(sourceFailoverConfig: FailoverConfig): FluentBuilder = apply { this.sourceFailoverConfig = sourceFailoverConfig }
        override fun sources(sources: List<Source>): FluentBuilder = apply { this.sources = sources }
        override fun status(status: Status): FluentBuilder = apply { this.status = status }
        override fun vpcInterfaces(vpcInterfaces: List<VpcInterface>): FluentBuilder = apply { this.vpcInterfaces = vpcInterfaces }
    }
}
