// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * The settings for a flow entitlement.
 */
class Entitlement private constructor(builder: BuilderImpl) {
    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    val dataTransferSubscriberFeePercent: Int? = builder.dataTransferSubscriberFeePercent
    /**
     * A description of the entitlement.
     */
    val description: String? = builder.description
    /**
     * The type of encryption that will be used on the output that is associated with this entitlement.
     */
    val encryption: Encryption? = builder.encryption
    /**
     * The ARN of the entitlement.
     */
    val entitlementArn: String? = builder.entitlementArn
    /**
     * An indication of whether the entitlement is enabled.
     */
    val entitlementStatus: EntitlementStatus? = builder.entitlementStatus
    /**
     * The name of the entitlement.
     */
    val name: String? = builder.name
    /**
     * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
     */
    val subscribers: List<String>? = builder.subscribers

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Entitlement = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Entitlement(")
        append("dataTransferSubscriberFeePercent=$dataTransferSubscriberFeePercent,")
        append("description=$description,")
        append("encryption=$encryption,")
        append("entitlementArn=$entitlementArn,")
        append("entitlementStatus=$entitlementStatus,")
        append("name=$name,")
        append("subscribers=$subscribers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferSubscriberFeePercent ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (entitlementArn?.hashCode() ?: 0)
        result = 31 * result + (entitlementStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (subscribers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Entitlement

        if (dataTransferSubscriberFeePercent != other.dataTransferSubscriberFeePercent) return false
        if (description != other.description) return false
        if (encryption != other.encryption) return false
        if (entitlementArn != other.entitlementArn) return false
        if (entitlementStatus != other.entitlementStatus) return false
        if (name != other.name) return false
        if (subscribers != other.subscribers) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Entitlement = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Entitlement
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        fun dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent: Int): FluentBuilder
        /**
         * A description of the entitlement.
         */
        fun description(description: String): FluentBuilder
        /**
         * The type of encryption that will be used on the output that is associated with this entitlement.
         */
        fun encryption(encryption: Encryption): FluentBuilder
        /**
         * The ARN of the entitlement.
         */
        fun entitlementArn(entitlementArn: String): FluentBuilder
        /**
         * An indication of whether the entitlement is enabled.
         */
        fun entitlementStatus(entitlementStatus: EntitlementStatus): FluentBuilder
        /**
         * The name of the entitlement.
         */
        fun name(name: String): FluentBuilder
        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
         */
        fun subscribers(subscribers: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         */
        var dataTransferSubscriberFeePercent: Int?
        /**
         * A description of the entitlement.
         */
        var description: String?
        /**
         * The type of encryption that will be used on the output that is associated with this entitlement.
         */
        var encryption: Encryption?
        /**
         * The ARN of the entitlement.
         */
        var entitlementArn: String?
        /**
         * An indication of whether the entitlement is enabled.
         */
        var entitlementStatus: EntitlementStatus?
        /**
         * The name of the entitlement.
         */
        var name: String?
        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
         */
        var subscribers: List<String>?

        fun build(): Entitlement
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.Encryption] inside the given [block]
         */
        fun encryption(block: Encryption.DslBuilder.() -> kotlin.Unit) {
            this.encryption = Encryption.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataTransferSubscriberFeePercent: Int? = null
        override var description: String? = null
        override var encryption: Encryption? = null
        override var entitlementArn: String? = null
        override var entitlementStatus: EntitlementStatus? = null
        override var name: String? = null
        override var subscribers: List<String>? = null

        constructor(x: Entitlement) : this() {
            this.dataTransferSubscriberFeePercent = x.dataTransferSubscriberFeePercent
            this.description = x.description
            this.encryption = x.encryption
            this.entitlementArn = x.entitlementArn
            this.entitlementStatus = x.entitlementStatus
            this.name = x.name
            this.subscribers = x.subscribers
        }

        override fun build(): Entitlement = Entitlement(this)
        override fun dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent: Int): FluentBuilder = apply { this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun encryption(encryption: Encryption): FluentBuilder = apply { this.encryption = encryption }
        override fun entitlementArn(entitlementArn: String): FluentBuilder = apply { this.entitlementArn = entitlementArn }
        override fun entitlementStatus(entitlementStatus: EntitlementStatus): FluentBuilder = apply { this.entitlementStatus = entitlementStatus }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun subscribers(subscribers: List<String>): FluentBuilder = apply { this.subscribers = subscribers }
    }
}
