// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Information about the encryption of the flow.
 */
class Encryption private constructor(builder: BuilderImpl) {
    /**
     * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     */
    val algorithm: Algorithm? = builder.algorithm
    /**
     * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
     */
    val constantInitializationVector: String? = builder.constantInitializationVector
    /**
     * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    val deviceId: String? = builder.deviceId
    /**
     * The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
     */
    val keyType: KeyType? = builder.keyType
    /**
     * The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    val region: String? = builder.region
    /**
     * An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
     */
    val roleArn: String? = builder.roleArn
    /**
     * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
     */
    val secretArn: String? = builder.secretArn
    /**
     * The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    val url: String? = builder.url

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Encryption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Encryption(")
        append("algorithm=$algorithm,")
        append("constantInitializationVector=$constantInitializationVector,")
        append("deviceId=$deviceId,")
        append("keyType=$keyType,")
        append("region=$region,")
        append("resourceId=$resourceId,")
        append("roleArn=$roleArn,")
        append("secretArn=$secretArn,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithm?.hashCode() ?: 0
        result = 31 * result + (constantInitializationVector?.hashCode() ?: 0)
        result = 31 * result + (deviceId?.hashCode() ?: 0)
        result = 31 * result + (keyType?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Encryption

        if (algorithm != other.algorithm) return false
        if (constantInitializationVector != other.constantInitializationVector) return false
        if (deviceId != other.deviceId) return false
        if (keyType != other.keyType) return false
        if (region != other.region) return false
        if (resourceId != other.resourceId) return false
        if (roleArn != other.roleArn) return false
        if (secretArn != other.secretArn) return false
        if (url != other.url) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Encryption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Encryption
        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         */
        fun algorithm(algorithm: Algorithm): FluentBuilder
        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
         */
        fun constantInitializationVector(constantInitializationVector: String): FluentBuilder
        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        fun deviceId(deviceId: String): FluentBuilder
        /**
         * The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        fun keyType(keyType: KeyType): FluentBuilder
        /**
         * The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        fun region(region: String): FluentBuilder
        /**
         * An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
         */
        fun secretArn(secretArn: String): FluentBuilder
        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        fun url(url: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         */
        var algorithm: Algorithm?
        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
         */
        var constantInitializationVector: String?
        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        var deviceId: String?
        /**
         * The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
         */
        var keyType: KeyType?
        /**
         * The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        var region: String?
        /**
         * An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        var resourceId: String?
        /**
         * The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
         */
        var roleArn: String?
        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
         */
        var secretArn: String?
        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         */
        var url: String?

        fun build(): Encryption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var algorithm: Algorithm? = null
        override var constantInitializationVector: String? = null
        override var deviceId: String? = null
        override var keyType: KeyType? = null
        override var region: String? = null
        override var resourceId: String? = null
        override var roleArn: String? = null
        override var secretArn: String? = null
        override var url: String? = null

        constructor(x: Encryption) : this() {
            this.algorithm = x.algorithm
            this.constantInitializationVector = x.constantInitializationVector
            this.deviceId = x.deviceId
            this.keyType = x.keyType
            this.region = x.region
            this.resourceId = x.resourceId
            this.roleArn = x.roleArn
            this.secretArn = x.secretArn
            this.url = x.url
        }

        override fun build(): Encryption = Encryption(this)
        override fun algorithm(algorithm: Algorithm): FluentBuilder = apply { this.algorithm = algorithm }
        override fun constantInitializationVector(constantInitializationVector: String): FluentBuilder = apply { this.constantInitializationVector = constantInitializationVector }
        override fun deviceId(deviceId: String): FluentBuilder = apply { this.deviceId = deviceId }
        override fun keyType(keyType: KeyType): FluentBuilder = apply { this.keyType = keyType }
        override fun region(region: String): FluentBuilder = apply { this.region = region }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun secretArn(secretArn: String): FluentBuilder = apply { this.secretArn = secretArn }
        override fun url(url: String): FluentBuilder = apply { this.url = url }
    }
}
