// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.model



/**
 * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
 */
class CreateFlowRequest private constructor(builder: BuilderImpl) {
    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The entitlements that you want to grant on a flow.
     */
    val entitlements: List<GrantEntitlementRequest>? = builder.entitlements
    /**
     * The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
     */
    val mediaStreams: List<AddMediaStreamRequest>? = builder.mediaStreams
    /**
     * The name of the flow.
     */
    val name: String? = builder.name
    /**
     * The outputs that you want to add to this flow.
     */
    val outputs: List<AddOutputRequest>? = builder.outputs
    /**
     * The settings for the source of the flow.
     */
    val source: SetSourceRequest? = builder.source
    /**
     * The settings for source failover
     */
    val sourceFailoverConfig: FailoverConfig? = builder.sourceFailoverConfig
    val sources: List<SetSourceRequest>? = builder.sources
    /**
     * The VPC interfaces you want on the flow.
     */
    val vpcInterfaces: List<VpcInterfaceRequest>? = builder.vpcInterfaces

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateFlowRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFlowRequest(")
        append("availabilityZone=$availabilityZone,")
        append("entitlements=$entitlements,")
        append("mediaStreams=$mediaStreams,")
        append("name=$name,")
        append("outputs=$outputs,")
        append("source=$source,")
        append("sourceFailoverConfig=$sourceFailoverConfig,")
        append("sources=$sources,")
        append("vpcInterfaces=$vpcInterfaces)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (entitlements?.hashCode() ?: 0)
        result = 31 * result + (mediaStreams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceFailoverConfig?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (vpcInterfaces?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateFlowRequest

        if (availabilityZone != other.availabilityZone) return false
        if (entitlements != other.entitlements) return false
        if (mediaStreams != other.mediaStreams) return false
        if (name != other.name) return false
        if (outputs != other.outputs) return false
        if (source != other.source) return false
        if (sourceFailoverConfig != other.sourceFailoverConfig) return false
        if (sources != other.sources) return false
        if (vpcInterfaces != other.vpcInterfaces) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateFlowRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateFlowRequest
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The entitlements that you want to grant on a flow.
         */
        fun entitlements(entitlements: List<GrantEntitlementRequest>): FluentBuilder
        /**
         * The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
         */
        fun mediaStreams(mediaStreams: List<AddMediaStreamRequest>): FluentBuilder
        /**
         * The name of the flow.
         */
        fun name(name: String): FluentBuilder
        /**
         * The outputs that you want to add to this flow.
         */
        fun outputs(outputs: List<AddOutputRequest>): FluentBuilder
        /**
         * The settings for the source of the flow.
         */
        fun source(source: SetSourceRequest): FluentBuilder
        /**
         * The settings for source failover
         */
        fun sourceFailoverConfig(sourceFailoverConfig: FailoverConfig): FluentBuilder
        fun sources(sources: List<SetSourceRequest>): FluentBuilder
        /**
         * The VPC interfaces you want on the flow.
         */
        fun vpcInterfaces(vpcInterfaces: List<VpcInterfaceRequest>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
         */
        var availabilityZone: String?
        /**
         * The entitlements that you want to grant on a flow.
         */
        var entitlements: List<GrantEntitlementRequest>?
        /**
         * The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
         */
        var mediaStreams: List<AddMediaStreamRequest>?
        /**
         * The name of the flow.
         */
        var name: String?
        /**
         * The outputs that you want to add to this flow.
         */
        var outputs: List<AddOutputRequest>?
        /**
         * The settings for the source of the flow.
         */
        var source: SetSourceRequest?
        /**
         * The settings for source failover
         */
        var sourceFailoverConfig: FailoverConfig?
        var sources: List<SetSourceRequest>?
        /**
         * The VPC interfaces you want on the flow.
         */
        var vpcInterfaces: List<VpcInterfaceRequest>?

        fun build(): CreateFlowRequest
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.SetSourceRequest] inside the given [block]
         */
        fun source(block: SetSourceRequest.DslBuilder.() -> kotlin.Unit) {
            this.source = SetSourceRequest.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.mediaconnect.model.FailoverConfig] inside the given [block]
         */
        fun sourceFailoverConfig(block: FailoverConfig.DslBuilder.() -> kotlin.Unit) {
            this.sourceFailoverConfig = FailoverConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZone: String? = null
        override var entitlements: List<GrantEntitlementRequest>? = null
        override var mediaStreams: List<AddMediaStreamRequest>? = null
        override var name: String? = null
        override var outputs: List<AddOutputRequest>? = null
        override var source: SetSourceRequest? = null
        override var sourceFailoverConfig: FailoverConfig? = null
        override var sources: List<SetSourceRequest>? = null
        override var vpcInterfaces: List<VpcInterfaceRequest>? = null

        constructor(x: CreateFlowRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.entitlements = x.entitlements
            this.mediaStreams = x.mediaStreams
            this.name = x.name
            this.outputs = x.outputs
            this.source = x.source
            this.sourceFailoverConfig = x.sourceFailoverConfig
            this.sources = x.sources
            this.vpcInterfaces = x.vpcInterfaces
        }

        override fun build(): CreateFlowRequest = CreateFlowRequest(this)
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun entitlements(entitlements: List<GrantEntitlementRequest>): FluentBuilder = apply { this.entitlements = entitlements }
        override fun mediaStreams(mediaStreams: List<AddMediaStreamRequest>): FluentBuilder = apply { this.mediaStreams = mediaStreams }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun outputs(outputs: List<AddOutputRequest>): FluentBuilder = apply { this.outputs = outputs }
        override fun source(source: SetSourceRequest): FluentBuilder = apply { this.source = source }
        override fun sourceFailoverConfig(sourceFailoverConfig: FailoverConfig): FluentBuilder = apply { this.sourceFailoverConfig = sourceFailoverConfig }
        override fun sources(sources: List<SetSourceRequest>): FluentBuilder = apply { this.sources = sources }
        override fun vpcInterfaces(vpcInterfaces: List<VpcInterfaceRequest>): FluentBuilder = apply { this.vpcInterfaces = vpcInterfaces }
    }
}
