// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconnect.serde

import aws.sdk.kotlin.services.mediaconnect.model.EntitlementStatus
import aws.sdk.kotlin.services.mediaconnect.model.UpdateEncryption
import aws.sdk.kotlin.services.mediaconnect.model.UpdateFlowEntitlementRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateFlowEntitlementOperationSerializer: HttpSerializer.NonStreaming<UpdateFlowEntitlementRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateFlowEntitlementRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.flowArn) { "flowArn is bound to the URI and must not be null" }
            requireNotNull(input.entitlementArn) { "entitlementArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("flows"))
                add(PercentEncoding.SmithyLabel.encode(input.flowArn))
                add(PercentEncoding.Path.encode("entitlements"))
                add(PercentEncoding.SmithyLabel.encode(input.entitlementArn))
            }
        }

        val payload = serializeUpdateFlowEntitlementOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFlowEntitlementOperationBody(context: ExecutionContext, input: UpdateFlowEntitlementRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENCRYPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryption"))
    val ENTITLEMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("entitlementStatus"))
    val SUBSCRIBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subscribers"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(ENCRYPTION_DESCRIPTOR)
        field(ENTITLEMENTSTATUS_DESCRIPTOR)
        field(SUBSCRIBERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.encryption?.let { field(ENCRYPTION_DESCRIPTOR, it, ::serializeUpdateEncryptionDocument) }
        input.entitlementStatus?.let { field(ENTITLEMENTSTATUS_DESCRIPTOR, it.value) }
        if (input.subscribers != null) {
            listField(SUBSCRIBERS_DESCRIPTOR) {
                for (el0 in input.subscribers) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
